 	cpu Z8601
	page 0
	include stddefZ8.inc

;********************************************************************
;
;              Apple "Rene" HD20 Controller - Z8 firmware
;                   Version 342-0343-B (3372)
;
;
;  commented and converted into as source by Patrick Schaefer, 2013
;      (some blocks were re-used from the Widget source code)
;
;    use as build 2011-08-02 or later. Last changes: 2013-09-30 PS
;
;********************************************************************


DontListIncls	SET 1

ROMsize		SET 8192
Checksum0	SET 098C6h		; for ROM test bank 0
Checksum1	SET 0B74Dh		;              bank 1
Passwrd1	SET 0F078h		; upper nibble high shifted right
Passwrd2	SET 03C1Eh
HiRevNumber	SET 033h	
LoRevNumber	SET 072h


; external calls into Z8 internal memory 341-0339-A
EpromTest	EQU 000E9h
MsWait		EQU 00124h
L0198		EQU 00198h
L01e2		EQU 001E2h
L01e7		EQU 001E7h
L01ec		EQU 001ECh
L01f0		EQU 001F0h
L01f8		EQU 001F8h
L01FF		EQU 001FFh
L0201		EQU 00201h
L0203		EQU 00203h
L0205		EQU 00205h
L0265		EQU 00265h
L028e		EQU 0028Eh
L029b		EQU 0029Bh
L02ab		EQU 002ABh
L02c9		EQU 002C9h
Bank_Call	EQU 002CBh
Bank_Ret	EQU 002F6h
Abort		EQU 00357h
SS_OpFail	EQU 0039Fh
L03a7		EQU 003A7h
SS_ReadErr	EQU 003ADh
SS_NoHdr	EQU 003B6h
SS_SprWarn	EQU 003BCh
SetStatus	EQU 003C2h
Reset_StMach	EQU 003C8h
Load_Header	EQU 003F0h
Load_Logical	EQU 00418h
Chk_Chk_Byte	EQU 00428h
Gen_Chk_Byte	EQU 00439h
L0450		EQU 00450h
L0459		EQU 00459h
LoadStatus	EQU 0046Ch
L047c		EQU 0047Ch
L0489		EQU 00489h
L048f		EQU 0048Fh
L049b		EQU 0049Bh
L04a3		EQU 004A3h
L04d0		EQU 004D0h
L04db		EQU 004DBh
L04e6		EQU 004E6h
L04ed		EQU 004EDh
L0501		EQU 00501h
L051b		EQU 0051Bh
Ext_Push	EQU 00522h
Ext_Pop		EQU 0054Fh
L0586		EQU 00586h
ZeroHeader	EQU 0058Eh
L059d		EQU 0059Dh
L05a3		EQU 005A3h
L05ba		EQU 005BAh
Load_PassWord	EQU 005E7h
L0651		EQU 00651h
AdjustGeometry	EQU 0065Bh
L069d		EQU 0069Dh
	

	include DefsHD20.inc

;********************************************************************
; Module Bank0.Assem
;
;********************************************************************

	org 0000h
	phase 1000h			; EPROM will start at 4k
	assume RP:Wrk_Sys
		DW Checksum0
		DB 0			; bank 0
Password	DW Passwrd1
		DW Passwrd2

; Vector Table
B0_VctTab
Start_Vector	jp Start_Command
RdL_Vector	jp Rd_Leave
Free_Vector	jp Strt_FreeProc1
SlfTst_Vector	jp SelfTest1
SprTbl_Vector	jp Load_SprTbl1
IScan_SprChk	jp Chk_SprCnt1
L1019		jp L106e
L101c		jp L106a
L101f		jp L10b4
L1022		jp L1cf4
L1025		jp L1cc3
L1028		jp L1caf
L102b		jp L1c80
L102e		jp L1cfa
L1031		jp L1c77

; Command Table
Cmnd_Ptrs	DW Sys_Read		;  0 MultiBlock Read
		DW Sys_Write		;  1 MultiBlock Write
		DW Sys_WrVer		;  2 MultiBlock WriteVerify
		DW L1587		;  3 
		DW Read_ID		;  4 Read Device ID
		DW Read_CStatus		;  5 Read Controller Status
		DW Read_SStatus		;  6 Read Servo Status
		DW Send_ServoCmnd	;  7 Send Servo Command
		DW Send_Seek		;  8 Seek
		DW Send_Restore		;  9 Data Recal / Brake Release
		DW Set_Recovery		;  A Set Recovery
		DW 0000Ch		;  B Soft Reset
		DW Send_Park		;  C Park
		DW D_Read		;  D Diag Read
		DW D_ReadHdr		;  E Diag Read Header
		DW D_Write		;  F Diag Write
		DW Set_AutoOffset	; 10 Auto Offset
		DW Read_SprTbl		; 11 Read Spare Table
		DW Wr_SprTbl		; 12 Write Spare Table
		DW Format		; 13 Format Track
		DW Abort_10		; 14 (Abort with code 10)
		DW Read_Abort		; 15 Read Abort Status
		DW D_RstSrvo		; 16 Reset Servo
		DW D_RdTrack		; 17 Read Track
		DW D_WrTrack		; 18 Write Track
		DW L17e4		; 19
		DW L17ee 		; 20

L106a		call L119d
		ret    

L106e		call L051b
		ld R14, #WEndGap /256
		ld R15, #WEndGap #256
		call Load_PassWord
		call L05ba
		ld R0, #0
		ld R1, #0
		call L04d0
		call L04ed
		clr R0
		call L04e6
		or 3Eh, #004h
		ret    

WrBlk_Vector	call WriteBlock
VctrB0_Ret	jp Bank_Ret
RdBlk_Vector	call ReadBlock
		jr VctrB0_Ret

Chk_SprCnt1	ld R2, #Chk_SprCnt /256
		ld R3, #Chk_SprCnt #256
VctrB0_BC	call Bank_Call
		jr VctrB0_Ret

Load_SprTbl1	ld R2, #Load_SprTbl /256
		ld R3, #Load_SprTbl #256
		jr VctrB0_BC

SelfTest1	ld R2, #SelfTest /256
		ld R3, #SelfTest #256
		jr VctrB0_BC

Strt_FreeProc1	ld R2, #Strt_FreeProcess /256
		ld R3, #Strt_FreeProcess #256
		jr VctrB0_BC

L10b4		jp L1169
		

; Device ID block
;
DeviceParams	DB "Rene-1 RM MH "	; device name
  		DB 000h, 002h, 010h	; device type
		DB HiRevNumber, LoRevNumber 
		DB 000h, 098h, 035h	; number of logical blocks
		DW 532			; number of bytes per block
Dev_Parm_Length	EQU $ - DeviceParams



;********************************************************************
; Module Cmnd.Assem
;
; This module controls the way in which commands received by
; the Host are executed. Its main responsibility is to determine
; whether a command string is protected by a check byte (the
; original ProFile commands are not) and then decode the command
; and pass control over to the correct driver routine to
; execute the command. All exception handling at this level is
; controlled by the individual command routines.
;
;	PROCEDURE Start_Command
;	PROCEDURE Pro_Read
;	FUNCTION Read_Common : BOOLEAN
;
;********************************************************************

;********************************************************************
;
; Procedure: StartCommand
;
;  Assumes a command string in external memory; the
;  command byte must be in location $0000 (external)
;
; Algorithm:
;
;  Begin
;    Initialize internal and external stack ptrs
;    ZeroHeader
;    Excpt_Stat.Buf_Damage:=false
;    Excpt_Stat.Nzero_Stat:=false
;    If Cache_Index = Cahe_Length
;      Then Cache_Index:=0
;    OpCode:=ExtMem[0]
;    If OpCode.CommandType is FreeProcess type
;      Then goto Strt_FreeProcess
;    If OpCode.CommandType is protected by a checkbyte
;      Then
;        If not(Check_Command_String)
;          Then Abort(Cmnd_Driver_Exception,
;                     Start_Command, CheckByte_Mismatch)
;    If OpCode.Instruction > CommandLimit[CommandType]
;      Then Abort(Cmnd_Driver_Exception,
;                 Start_Command, IllegalOpCode, OpCode)
;    JMP @Command^[CommandType].RoutineTable[Instruction]
;  End
;
;********************************************************************

Start_Command 	di     
		srp #Wrk_Sys		; get into a reasonable state
	assume RP:Wrk_Sys
		ld SPL, #Stack_Top
		or Excpt_Stat, #UseECC
		and Excpt_Stat, #0FFh-NZero_Stat-002h	; ???
		and 3Eh, #0FFh-S_Block-B_Block-002h
		call L051b
		call L028e
		ld R2, #Cmnd_Ptr /256	; host passes command here
		ld R3, #Cmnd_Ptr #256
		lde R4, @RR2		; command byte into Status0
		ld Status0, R4
		or Status0, #080h	; set bit 7
		ld Status1, #0		; clear Status1
; copy host command into HostCmndBuf
		ld R14, #(HostCmndBuf) /256
		ld R15, #(HostCmndBuf) #256
		ld R1, #8		; copy 8 bytes
St_L_Lp		lde R0, @RR2
		lde @RR14, R0
		incw RR2
		incw RR14
		djnz R1, St_L_Lp
;
		and 50h, #0FFh-010h
		cp R4, #2		; cmd 0..2?
		jp LE, Chk_Inst		;  --> these need passed selftest!
		cp R4, #5		; cmd 5 (controller status)?
		jp Z, Ok_Inst		;  -->
Chk_Inst1	ld R2, #014h
		ld R3, #07Bh
		ld R1, #4
		ld R0, #0
		call L0450
		jp Ok_Inst
; cmd 0..2
Chk_Inst	or SlfTst_Result,SlfTst_Result	; check if we're not healthy
		jr nz, Inst_Abort1
		or 50h, #010h
		jr Chk_Inst1

; jump to command subroutine, command number in R4
Ok_Inst		ld R14, #Cmnd_Ptrs /256	; offset to command vector table
		ld R15, #Cmnd_Ptrs #256
		rcf    
		rl R4			; *2
		add R15, R4		; get offset into table
		ldc R12, @RR14		; get address to routine
		incw RR14
		ldc R13, @RR14
		jp @RR12		; jump to routine


; Cmd 14: Abort with code 10 
Abort_10	ld R15, #10
Inst_Abort	jp Abort
;
Abort_8		ld R15, #8
		jr Inst_Abort
;
Inst_Abort1	ld R15, #9		; command rejected because selftest failed
		jr Inst_Abort


; we arrive here after completion of any command
Rd_Leave  	and 3Eh, #0FFh-010h-008h
		call L1169		; assemble status word
L114c		jp L0198


Pro_Rd_BB	ld R2, #RBuf_To_Buf2 /256
		ld R3, #RBuf_To_Buf2 #256
		call Bank_Call
		ld R0, #Error+Ex_SprBlock	; Spare this block!
		tcm R0, #Error		; set Z flag
		ret
    

Wr_BBlock	ld R2, #WrBuf_To_Buf2 /256
		ld R3, #WrBuf_To_Buf2 #256
		call Bank_Call
		ld R0, #Error+Ex_SprBlock	; Spare this block!
		call Data_Ex_Handler
		ret    


; send completion status
L1169		tm Excpt_Stat, #SprTbl_Warn
		jr Z, L1175
		ld R0, #0
		ld R1, #080h
		call L029b

L1175		ld R0, #2
		ld R1, 5Dh
		call L029b
		ld R14, #(RBuffer1-6) /256	; RAM 1013h
		ld R15, #(RBuffer1-6) #256
		ld R2, #014h
		ld R3, #07Bh		; 147Bh
		ld R0,Status0
		lde @RR14, R0		; first Status0
		incw RR14
		ld R0,Status1
		lde @RR14, R0		; then Status1
		incw RR14
		ld R1, #4
Move4_Lp	lde R0, @RR2		; then 147B..147Eh
		lde @RR14, R0
		incw RR14
		incw RR2
		djnz R1,Move4_Lp
		ret    

L119d		call L028e
		ld 5Dh, #0
		ret    

WrVer_Common	or DiskStat, #Wr_Op+Offset_On+User_Type
		call RW_Common
		jr Z, WrVer_Ret
		ld R2, #WrBuf_To_Buf2 /256
		ld R3, #WrBuf_To_Buf2 #256
		call Bank_Call
		and DiskStat, #0FFh-Wr_Op
		call RW_Common
		jr Z, WrVer_Ret1
L11bb		jp Bank_Ret
WrVer_Ret1	cp R0, #088h
		jr nz, L11c7
		ld R0, #08Ah
		jr WrVer_Ret
L11c7		cp R0, #084h
		jr nz, WrVer_Ret
		ld R0, #082h
WrVer_Ret	call Data_Ex_Handler
		jr L11bb

RW_Common	tm DiskStat, #Wr_Op	; are we writing?
		jr Z, RW_Cmd_Rd
		call WriteBlock
		jr NZ, L1259
		jr L11e4

RW_Cmd_Rd	call ReadBlock
		jr NZ, L1259

L11e4		push R4
		tm Excpt_Stat, #NZero_Stat
		jr NZ, L11f1
		call L03a7
		or Excpt_Stat, #NZero_Stat
L11f1		tm DiskStat, #Wr_Op
		jr Z, L11fd
		ld R2, #WrBuf_To_Buf2 /256
		ld R3, #WrBuf_To_Buf2 #256
		call Bank_Call
L11fd		ld R4, #080h
		tm Excpt_Stat, #Recovery
		jr Z, L1252

L1204		ld R4, #086h
		ld R6, #004h
L1208		tm RWStat, #RdSrvoErr+RdNoHdrFnd+RdSMErr
		jr Z, L1273
L120d		push DiskStat
		ld R2, #SrvoRcvry /256
		ld R3, #SrvoRcvry #256
		call Bank_Call
		pop DiskStat
		tm DiskStat, #Wr_Op
		jr Z, L1229
L121d		ld R2, #Buf2_To_WrBuf /256
		ld R3, #Buf2_To_WrBuf #256
		call Bank_Call
		call WriteBlock
		jr L1237

L1229		call ReadBlock
		jr Z, L1237
		ld R2, #RBuf_To_Buf2 /256
		ld R3, #RBuf_To_Buf2 #256
		call Bank_Call
		jr L1252

L1237		djnz R6, L1208
		ld R4, #080h
		tm RWStat, #RdSrvoErr
		jr Z, L1248
		call SetStatus
		ld R15, #11
		jp Abort

L1248		tm RWStat, #RdSMErr
		jr Z, L125c
		ld R15, #26
		jp Abort

L1252		ld R0, R4
		pop R4
		tcm R0, #080h
L1259		jp Bank_Ret

L125c		tm RWStat, #RdNoHdrFnd
		jr Z, L126e
		tm DiskStat, #Wr_Op
		jr Z, L126a
		ld R4, #08Ah
		jr L1252

L126a		ld R4, #88h
		jr L1252

L126e		tm DiskStat, #Wr_Op
		jr NZ, L1252
L1273		ld R0, R9
		and R0, #00Fh
		cp R0, #3
		jr LE, L1286
		cp R0, #00Ah
		jr Z, L128a
		ld R4, #082h
		jr L1252

L1286		ld R4, #086h
		jr L1252

L128a		ld R4, #084h
		jr L1252



;********************************************************************
; Module Spare.Assem
;
; This module contains all the routines that pertain
; to the management of the spare table.
;
;	PROCEDURE SprBlock( SpareType : BIT {R10/bit 7} )
;	PROCEDURE SpareBlock( BlockIsSpare : BOOLEAN {R10/bit 4} )
;
;********************************************************************

;********************************************************************
;
; Procedure: SprBlock {spare a block}
;
;  This procedure is responsible for relocating a logical
;  block (note that the block type can be USER or SPARETABLE)
;  from either the user data area or the spare area to
;  some location within the spare area.
;
;  This procedure is capable of gobbling up ALL available spare
;  block space and will ABORT if no space is available.
;
; Inputs: SpareType: BIT {R10/Bit 4}
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    If SpareType=Spare
;      Then
;        If BlkStat.SpareCode=BadBlock
;          Then
;            DeleteSpare
;            SpareCount(Dec_BadCnt)
;        BlockMove(WBuffer1, Buffer2)
;        If not(WrVer_Common)
;          Then SpareBlock(SpareType)
;      Else SpareBlock(BadBlockType)
;    UpDate_SprTbl
;    BlockMove(Buffer2, RBuffer1)
;  End
;
;********************************************************************

SprBlock	tm R10, #Spare		; If SpareType=Spare
		jr Z, SprBlk_1
;
		tm 3Eh, #B_Block
		jr Z, SprBlk_2
;
		ld R2, #DeleteSpare /256
		ld R3, #DeleteSpare #256
		call Bank_Call
		ld R0, #Dec_BadCnt
		ld R2, #SpareCount /256
		ld R3, #SpareCount #256
		call Bank_Call
SprBlk_2	ld R2, #ReSeek /256
		ld R3, #ReSeek #256
		call Bank_Call
		ld R4, #10		; bang on this block for a while
		ld R6, #0		; init error count
Spr_WrVer	ld R2, #Buf2_To_WrBuf /256
		ld R3, #Buf2_To_WrBuf #256
		call Bank_Call
		or DiskStat, #Wr_Op
		call Ext_Push
		call RW_Common
		push FLAGS
		call Ext_Pop
		pop FLAGS
		jr Z, SprBlk_1		; check for write error
		and DiskStat, #0FFh-Wr_Op
		call Ext_Push
		call RW_Common
		push FLAGS
		call Ext_Pop
		pop FLAGS
		jr NZ, SprWrV_1
		ld R0, R9		; get read error count
		and R0, #00Fh		; mask off status info
		jr Z, SprBlk_1		; check for header failure
		cp R0, #SprThresh
		jr GT, SprBlk_1		; spare the block if over threshold
		add  R6, R0		; bump cumulative error count
SprWrV_1	djnz R4, Spr_WrVer
		cp R6, #SprThresh	; take a percentage of total reads
		jr GT, SprBlk_1
;
		tm 3Eh, #B_Block
		jr NZ, SprBlk_3
SprBlk_1	call SpareBlock
;
SprBlk_3	ld R2, #UpDate_SprTbl /256
		ld R3, #UpDate_SprTbl #256
		call Bank_Call
		ld R2, #Buf2_To_RBuf /256
		ld R3, #Buf2_To_RBuf #256
		call Bank_Call
		ret  
  

;********************************************************************
;
; Procedure: SpareBlock
;
;  This procedure performs the actual sparing.
;
; Inputs: SpareType: BIT {R10/Bit 4}
;
; Outputs: none
;
; Local Variables: SparingASpare: BOOLEAN {R9}
;                  SpareLocation: BYTE {R4}
;                  Error:         BOOLEAN {R5}
;
; Algorithm:
;
;  Begin
;    If BlkStat.SpareCode=BadBlock
;      Then
;        AddSpare(GetNewSpare(Load_Logical), Load_Logical, BadBlock)
;        SpareCount(Inc_BadCnt)
;      Else
;        Repeat
;          If BlkStat.SpareCode=Spare
;            Then
;              Location:=CnvrtLogical(Load_Logical)
;              Ptr:=Get_Ptr(Location)
;              Ptr^.Useable:=false
;          SpareCount(Inc_SprCnt)
;          BlkStat.SpareCode:=SpareBlock
;          Location:=GetNewSpare(Load_Logical)
;          AddSpare(Location, Load_Logical, SpareBlock)
;          Seek_Type:=Access_Offset
;          Seek(Get_Cyl_H_S(MulR0_m(Location)))
;        Until WrVer_Common
;  End
;
;********************************************************************

SpareBlock	ld R0, #1		; byte 1
		ld R1, #Stat_Spare
		call L029b		; SetStatus
		tm R10, #Spare
		jr NZ, S_Blk_Rpt
;
		tm 3Eh, #B_Block
		jr NZ, S_Blk_End
;
		call Load_Logical
		ld R2, #GetNewSpare /256
		ld R3, #GetNewSpare #256
		call Bank_Call
		ld R15, R0
		ld R8, #BadBlock
		ld R2, #AddSpare /256
		ld R3, #AddSpare #256
		call Bank_Call
		ld R0, #Inc_BadCnt
		ld R2, #SpareCount /256
		ld R3, #SpareCount #256
		call Bank_Call
		jr S_Blk_End
;
S_Blk_Rpt	call Load_Logical
		call Spr_Enter
		jr NZ, S_Blk_End
		cp R0, #Error+Ex_ReadErr	; check for sparing threshold
		jr NZ, S_Blk_Rpt
S_Blk_End	jp Bank_Ret
;
Spr_Enter	tm 3Eh, #S_Block
		jr Z, S_Blk_New
		call CnvrtLogical
		jr NZ, S_Blk_Unuse
		ld R15, #12
		jp Abort
;
S_Blk_Unuse	ld R0, R1
		call Get_Ptr
		lde R0, @RR2		; element useable:=false
		and R0, #0FFh-Useable
		lde @RR2, R0
;
S_Blk_New	ld R0, #Inc_SprCnt
		ld R2, #SpareCount /256
		ld R3, #SpareCount #256
		call Bank_Call
		and 3Eh, #0FFh-B_Block-S_Block	; mask out the SpareCode stuff
		or 3Eh, #S_Block
		call Load_Logical
		ld R2, #GetNewSpare /256
		ld R3, #GetNewSpare #256
		call Bank_Call
		ld R15, R0
		ld R8, #Spare
		ld R2, #AddSpare /256
		ld R3, #AddSpare #256
		call Bank_Call
		or DiskStat, #Offset_On
		call Load_Logical
		call OverLap
		tm 3Eh, #S_Block
		jp NZ, S_Blk_New1
		ld R15,SlfTst_Result
		jp Abort
;
S_Blk_New1	tm DiskStat, #User_Type
		jr NZ, Spr_LdBuf2
		ld R2, #SprChkSum /256	; calculate new checkbyte
		ld R3, #SprChkSum #256
		call Bank_Call
		ld R2, #Spr_To_WrBuf /256
		ld R3, #Spr_To_WrBuf #256
		jr Spr_LdWrBuf
Spr_LdBuf2	ld R2, #Buf2_To_WrBuf /256
		ld R3, #Buf2_To_WrBuf #256
Spr_LdWrBuf	call Bank_Call
		call WrVer_Common
		jp Bank_Ret



;********************************************************************
; Module Data.X.Assem
;
; Data Exception Handling
;
;	PROCEDURE: Data_Ex_Handler( ErrorCode : 7 BITS {R0/Bits 6:0} )
;
;********************************************************************

;********************************************************************
;
; Procedure: Data_Ex_Handler  {data exception handler}
;
;  This procedure is responsible for cleaning up after some sort
;  of data error (spareing, bad-blocking, etc). It is
;  assumed that if spareing is going to occur that correct data must
;  be residing in Buffer2.
;
; Inputs: ErrorCode: 7 BITS {R0/Bits 6:0}
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    If not(DiskStatus.Wr_Op) Then SetStatus(ReadError)
;    Case ErrorCode Of
;      0: SetStatus(OperationFailed)
;      2: Spare(Spare)
;      4: Spare(BadBlock)
;         SetStatus(OperationFailed)
;      6: SetStatus(ErrorCount)
;      8: SetStatus(NoHeaderFound)
;         Spare(Spare)
;      Otherwise Abort
;  End
;
;********************************************************************

Data_Ex_Handler	push R0			; save error code
		call Ext_Push		; save state
		tm DiskStat, #Wr_Op
		jr NZ, Data_Ex_RdErr
		call SS_ReadErr		; SetStatus ???
Data_Ex_RdErr	pop R1			; get error code back
		and R1, #07Fh		; mask off error flag
		tm  R1, #1		; see if error code is odd
		jr NZ, Data_Ex_Abort
		cp R1, #Ex_Case_Max	; bounds check
		jr LE, Data_Ex_Cmnd
Data_Ex_Abort	ld R15, #15
		jp Abort
;
Data_Ex_Cmnd	ld R2, #Ex_Jp_Tbl /256
		ld R3, #Ex_Jp_Tbl #256
		add R3, R1		; add offset
		adc R2, #0
		ldc R14, @RR2		; get routine to execute
		incw RR2
		ldc R15, @RR2
		jp @RR14		; go to routine

Ex_Jp_Tbl	DW X_Undeter 
		DW X_Spare
		DW X_BadBlock
		DW X_ReadErr
		DW X_HdrBadBlock
		DW X_HdrSpare

X_Undeter	call SS_OpFail
		jr Except_Return
;
X_Spare		ld R10, #Spare
X_Spr_Call	call SprBlock
		jr Except_Return
;
X_BadBlock	ld R4, #2		; retry 2 times
X_BB_Lp		push R4
		call Bad_Recover
		pop R4
		jr NZ, X_Spare
		djnz R4, X_BB_Lp
		call SS_OpFail
		ld R10, #BadBlock
		jr X_Spr_Call
;
X_ReadErr	call SS_ReadErr
		ld R2, #Buf2_To_RBuf /256
		ld R3, #Buf2_To_RBuf #256
		call Bank_Call
;
Except_Return	call Ext_Pop
		jp Bank_Ret
;
X_HdrBadBlock	call Bad_Recover
		jr NZ, X_Spare
		call SS_NoHdr
		tm 3Eh, #HDA_Type	; do we have a Rodime HDA?
		jr NZ, X_HdrBadBk1	;  yes -->
		call AdjustGeometry		
		jr X_HdrBadBk2
X_HdrBadBk1	jr X_BadBlock
X_HdrBadBk2	ld R2, #ReadHdr /256
		ld R3, #ReadHdr #256
		call Bank_Call
		jr Z, X_Hdr_Crct
		ld R2, #RBuf_To_Buf2 /256
		ld R3, #RBuf_To_Buf2 #256
		call Bank_Call
		jr X_Spare
;
X_Hdr_Crct	ld R2, #ECC /256
		ld R3, #ECC #256
		call Bank_Call
		jr Z, X_BadBlock
;
X_HdrSpare	call SS_NoHdr
		jr X_Spare


; this belongs to D_ReadHdr and is called with a Rodime HDA installed
D_RdH_3		or Sector,Sector
		jr Z, L1469
		call AdjustGeometry
		jr L147a
L1469		ld Sector, #31
		call AdjustGeometry
		and IRQ, #0FFh-Irq_Sector	; clear any old sector marks
		ld R2, #1
		call L069d
		ld Sector, #0
L147a		ret    


;********************************************************************
;
; Function: Bad_Recover
;
;  This function is called when a block can not be read, either the
;  header can not be found or there is a hard data error. The purpose
;  here is to use the auto offset capabilities of the servo controller
;  and reread the block.
;
; Inputs: none
;
; Outputs: Bad_Recover: BOOLEAN {zero flag set if failure on retry}
;
;********************************************************************

Bad_Recover	tm DiskStat, #Offset_Set	; check for auto_offset
		jr NZ, B_Rcvr_Read
		call ReSeek
B_Rcvr_Read	and DiskStat, #0FFh-Wr_Op
		call RW_Common
		jr NZ, Bad_Rcvr_Ret
		cp R0, #Error+Ex_ReadErr
		jr Z, Bad_Rc_Spr
		cp R0, #Error+Ex_BadBlock
		jr Z, Bad_Rc_Ecc
		cp R0, #Error+Ex_SprBlock
		jr Z, Bad_Rc_Spr
		ld R0, #0
Bad_Rc_Set	or R0, R0
		jr Bad_Rcvr_Ret
Bad_Rc_Spr	ld R0, #1
		jr Bad_Rc_Set
Bad_Rc_Ecc	ld R2, #ECC /256
		ld R3, #ECC #256
		call Bank_Call
Bad_Rcvr_Ret	ret    



;********************************************************************
; Module SprUtils.Assem
;
; This module contains all the primitive utility procedures used by
; the module: Spare
;
;	FUNCTION Get_HeadPtr( LogicalBlock : 3 BYTES {R12:14} ) : 
;		BOOLEAN
;		HeadPtr : BYTE {R0}
;		ArrayPtr : PTR {RR2}
;		FUNCTION Get_EoList( Start_Ptr : BYTE {R0} ) : 
;		SparePtr : BYTE {R0}
;		ElementStatus : BYTE {R1}
;		Ptr : PTR {RR2}
;		PreviousPtr : PTR {ScrReg0:1}
;	FUNCTION TSC_BitMap( TestBit : BOOLEAN {R12/bit 7}
;		SetBit : BOOLEAN {R12/bit 6}
;		ClearBit : BOOLEAN {R12/bit 5}
;		Location : BYTE {R13} ) : BOOLEAN
;	FUNCTION Get_Ptr( SparePtr : BYTE {R0} ) : Ptr : PTR {R2}
;	FUNCTION Get_Spr_Code : 2 BITS {R0/Bits 1:0}
;
;********************************************************************

;********************************************************************
;
; Function: Get_HeadPtr
;
;  This function searches the SegPtrArray (that array for the spare
;  table that contains the various head ptrs for the spare table) and
;  returns the HeadPtr that corresponds to the list whose elements all
;  have the first 7 bits of the (passed in) LogicalBlockNumber.
;
; Inputs: LogicalBlockNumber : 3 BYTES {R12:14}
;
; Outputs: Get_HeadPtr : BOOLEAN {zero is set if HeadPtr.Nil is true}
;          HeadPtr     : BYTE {R0}
;          ArrayPtr    : Ptr {RR2} {ptr to location in array}
;
; Algorithm:
;
;  BEGIN
;    HeadPtr :=  SegPtrArray[ LogicalBlockNumber/bits 10:16 ]
;    Get_HeadPtr := NOT( HeadPtr.Nil )
;  END
;
;********************************************************************

Get_HeadPtr	ld R1, R13		; bits 8:15 of logical block #
		and R1, #0FCh
		rr R1			; divide by 4
		rr R1
		ld R2, #SegPtrArray /256
		ld R3, #SegPtrArray #256
		add R3, R1		; add in offset to array
		adc R2, #0
		lde R0, @RR2		; load HeadPtr
		tcm R0, #Nil		; test for Nil Ptr
		jp Bank_Ret


;********************************************************************
;
; Function: Get_EoList (Get End-Of-List)
;
;  This function takes a starting ptr as an input parameter and
;  follows the list specified by the ptr until the list terminates.
;  A pointer to the last element of the array is returned to the
;  caller.
;
; Inputs: Start_Ptr : BYTE {R0}
;
; Outputs: Ptr : PTR {RR2}
;          SparePtr : BYTE {R0}
;          Element.Status : BYTE {R1}
;          PreviousPtr : PTR {ScrReg6,7}
;
; Algorithm:
;
;  BEGIN
;    Ptr := Get_Ptr( Start_Ptr )
;    WHILE NOT( Get_Ptr( Temp )^.Nil ) DO
;      PreviousPtr := Get_Ptr( Temp )
;      Temp := PreviuosPtr^.Ptr
;      Ptr := Get_Ptr( Temp )
;      Element.Status := Ptr^.Status
;  END
;
;********************************************************************

Get_EoList	ld ScrReg3, R0
		call Get_Ptr		; create ptr into Spare Table
		lde R1, @RR2		; get element status
		tm R1, #Nil		; IF Nil THEN Exit Loop
		jr NZ, Get_EL_Done
		ld ScrReg6, R2		; save Ptr to element i - 1
		ld ScrReg7, R3
		add R3, #3		; get ptr to next
		adc R2, #0
		lde R0, @RR2
		jr Get_EoList
Get_EL_Done	jp Bank_Ret


;********************************************************************
;
; Function: TSC_BitMap  (Test, Set, Or Clear BitMap Location)
;
;  This function performs one of 3 functions: Set a bit location in
;  the Spare Table bit map; Clear a location in the Spare Table bit
;  map; or Test a location in the spare table bit map. The location
;  to test, set, or clear is an integer value between 0 and 75.
;
; Inputs: TestBit : BOOLEAN {R12/bit 7}
;         SetBit  : BOOLEAN {R12/bit 6}
;         ClearBit : BOOLEAN {R12/bit 5}
;         Location : BYTE {R13}
;
; Outputs: TSC_BitMap : BOOLEAN {zero is set if location is zero}
;
; Global Variables Changed: SpareBitMap
;
;********************************************************************

TSC_BitMap	ld R0, R13
		ld R3, #3		; right hand justify the byte index
TSC_Lp1		rcf    
		rrc R0
		djnz R3, TSC_Lp1
		ld R2, #SpareBitMap /256
		ld R3, #SpareBitMap #256
		add R3, R0
		adc R2, #0		; inc second byte of address if needed
		lde R1, @RR2		; load in the byte from bit map
		and R13, #007h		; mask off all but MOD 8 of original 
		ld R0, #TestBitMap	; convert index to mask
		jr Z, TSC_Map
TSC_Lp2		rr R0
		djnz R13, TSC_Lp2
TSC_Map		push R0			; save mask
		tm R12, #TestBitMap
		jr NZ, TSC_End
		tm R12, #SetBitMap
		jr NZ, TSC_Set
TSC_Clear	com R0
		and R1, R0		; mask out bit
		jr TSC_SCEnd
;
TSC_Set		or R1, R0		; merge in bit
TSC_SCEnd	lde @RR2, R1		; update the bit map
TSC_End		pop R0
		tm R1, R0		; test the bit
		jp Bank_Ret


;********************************************************************
;
; Function: Get_Ptr
;
;  This function accepts a Spare Table ptr structure and creates a
;  real ptr into the Spare Table array.
;
; Inputs: SparePtr : BYTE {R0}
;
; Outputs: SParePtr : BYTE {R0} {input is unchanged}
;          Ptr : PTR {RR2}
;
;********************************************************************

Get_Ptr		ld R2, #SpareTable /256
		ld R3, #SpareTable #256
		push R0			; save structure ptr
		ld R1, R0
		clr R0
		add R1, R1		;  RR0 := 4 * R1
		add R1, R1
		adc R0, #0
		add R3, R1		; add offset into table
		adc R2, R0
		pop R0			; get original structure ptr back
		jp Bank_Ret



;********************************************************************
; Module Cmnd0.Assem   {Command Driver 0}
;
;  This module controls the way in which commands received by the
;  Host are executed. It's main responsibility is to determine whether
;  a command string is protected by a check byte (the original Profile
;  commands are not) and then decode the command and pass control over
;  to the correct driver routine to execute the command. All exception
;  handling at this level is controlled by the individual command
;  routines.
;
;	PROCEDURE Read_ID
;	PROCEDURE Read_SprTbl
;	PROCEDURE Pro_Write
;	FUNCTION RW_Common : BOOLEAN
;	PROCEDURE Pro_WrVer
;	FUNCTION WrVer_Common : BOOLEAN
;
;********************************************************************

;********************************************************************
;
; Procedure: Read_ID
;
;  This procedure is responsible for letting the host system
;  know what type of device it is talking to
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    ClrNormStat
;    ZeroRdBuf
;    ID.DeviceName:=DeviceName
;    ID.DeviceNumber:=DeviceNumber
;    ID.Revision:=RevisionNumber
;    ID.Capacity:=Capacity
;    ID.BlockSize:=BlockSize
;    Move4(StatusArray, Status)
;    Goto Rd_Leave
;  End
;
;********************************************************************

Read_ID		ld R12, #RBuffer1 /256
		ld R13, #RBuffer1 #256
		ld R14, #DeviceParams /256	; ID block
		ld R15, #DeviceParams #256
		ld R1, #Dev_Parm_Length	; copy 23 bytes
Read_ID_Lp1	ldc R0, @RR14
		lde @RR12, R0
		incw RR12
		incw RR14
		djnz R1, Read_ID_Lp1
		tm 3Eh, #HDA_Type	; do we have a Nisha HDA?
		jr Z, Read_ID1		;  yes -->
		ld R2, #NbrTracks_A /256	; set geometry for Rodime
		ld R3, #NbrTracks_A #256
		ld R4, #NbrHds_A		
		jr Read_ID2
Read_ID1	ld R2, #NbrTracks_B /256	; set geometry for Nisha
		ld R3, #NbrTracks_B #256
		ld R4, #NbrHds_B
Read_ID2	ld R5, #NbrSctrs 	; number of sectors
		ld R6, #0		; number of possible spare locations
		ld R7, #0
		ld R8, #76
		ld R14, #SprCount /256
		ld R15, #SprCount #256
		lde R9, @RR14		; get spare count
		incw RR14
		lde R10, @RR14		; point to bad block count
		ld R0, #012h		; start with R2 in Wrk_Sys
		ld R1, #9
Read_ID_Lp2	ldei @RR12, @R0
		djnz R1, Read_ID_Lp2
		jp Rd_Leave


;********************************************************************
;
; Procedure: Read_SprTbl
;
;  This procedure is responsible for passing the spare table on to
;  the host. Note that this information is sent in it's raw form and
;  that it is up to the host to correctly interpret it.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    RBuffer1:=SpareArray
;    Move4(StatusArray, Status)
;    Clr_Bsy(StatusArray)
;  End
;
;********************************************************************

Read_SprTbl	ld R2, #Spr_To_RBuf /256
		ld R3, #Spr_To_RBuf #256
		call Bank_Call
		jp Rd_Leave


; Cmd 3
L1587		ld R2, #L2CEC /256
		ld R3, #L2CEC #256
		call Bank_Call
		jp Rd_Leave



;********************************************************************
; Module Cmnd1.Assem  {continuation of the command processor module}
;
;	PROCEDURE D_Read
;	PROCEDURE D_ReadHdr
;	PROCEDURE D_Write
;	PROCEDURE Read_CStatus
;	PROCEDURE Read_SStatus
;	PROCEDURE Send_ServoCmnd
;	PROCEDURE Send_Seek
;	PROCEDURE Send_Restore
;	PROCEDURE Send_Park
;	PROCEDURE Set_Ram_Addr
;	PROCEDURE Wr_SprTbl
;	PROCEDURE Format
;	PROCEDURE Read_Abort
;	PROCEDURE D_RstSrvo
;	PROCEDURE D_InitSprTbl
;
;*******************************************************************

;********************************************************************
;
; Procedure: D_Read
;
;  The Diag_Read conmand is used to read the block on the disk pointed
;  to by the last seek address. The form of the returned data is
;  exactly the same as that of ProFile_Read or Sys_Read in that 4
;  bytes of Standard_Status precede the block of data. 
;
; Inputs: <Sector><SeqValue>
;         Sector = 0..31
;         SeqValue = NewSector/IncSector/Long
;
;   NewSector = $80 {selects 'Sector' as the sector to be operated on}
;   IncSector = $40 {increments the last sector value}
;   Long = $20 {if Long then the ECC syndrome will be ignored and the
;               checkbytes will be included at the end of the data}
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    ClrNormStat
;    Ack_Read(D_Read_Response)
;    If not(Read_Common)
;      Then Data_Ex_Handler(Read_Common.ErrorCode)
;    Rd_Leave
;  End
;
;********************************************************************

; Cmd D 09 Diag Read
D_Read		call Get_SeqValue
		or DiskStat, #User_Type
		and DiskStat, #0FFh-Wr_Op
		call RW_Common
		jr NZ, D_Read_End
		call L03a7
		ld R0, #Error+Ex_Undetermined
		call Data_Ex_Handler
D_Read_End	jp Rd_Leave
;
Get_SeqValue	call Get_HostParms
		tm R1, #080h		; NewSector?
		jr Z, Get_SeqVal1	;  no, try next
		ld Sector, R0		; get sector from R0
		jr Get_SeqVal2
Get_SeqVal1	tm R1, #040h		; IncSector?
		jr Z, Get_SeqVal2	;  no, try next
		inc Sector		; increment sector number
Get_SeqVal2	tm R1, #020h		; Long?
		jr Z, Get_SeqVal3	;  no, exit
		and Excpt_Stat, #0FFh-UseECC
Get_SeqVal3	ret    


;********************************************************************
;
; Procedure: D_ReadHdr
;
;  This diagnostic command is used to read the header (and whatever
;  the contents may be) of the block pointed to by the last seek
;  address. The host should be cautioned that the buffer that the
;  controller points it to at the completion of the read is longer
;  than a normal read buffer by the length of the header and the
;  data gap.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    ClrNormStat
;    Ack_Read(D_RdHdr_Response)
;    Sector:=LdParam1.First
;    LocateSector
;    ReadHdr
;    If ReadHdr.ServoErr Then SetStatus(Byte0, ServoErr)
;    If ReadHdr.CrcErr Then SetStatus(Byte0, ReadError)
;    Move4(RdHdrStatusArray, CStatus0)
;    Clr_Bsy(RdHdrStatusArray)
;  End
;
;********************************************************************

; Cmd E 0A Diag Read Header
D_ReadHdr	call Get_SeqValue
		tm 3Eh, #HDA_Type	; Rodime mechanism?
		jr NZ, D_RdH_1		;  yes --> 
		call AdjustGeometry
		jr D_RdH_2
D_RdH_1		call D_RdH_3
D_RdH_2		or DiskStat, #SeekComplete
		and DiskStat, #0FFh-Wr_Op
		ld R2, #ReadHdr /256
		ld R3, #ReadHdr #256
		call Bank_Call
		jr NZ, D_RdH_End
		call L03a7
		tm RWStat, #RdHSrvoErr	; If ReadHdr.ServoErr
		jr Z, D_RdH_Crc
		call SetStatus
;
D_RdH_Crc	tm RWStat, #RdCrcErr
		jr Z, D_RdH_End
		call SS_ReadErr
;
D_RdH_End	ld R14, #RHHeader /256
		ld R15, #RHHeader #256
		ld R2, #RHEndGap /256
		ld R3, #RHEndGap #256
		ld R1, #6
D_RdH_Lp	lde R0, @RR14
		lde @RR2, R0
		incw RR2
		incw RR14
		djnz R1, D_RdH_Lp
		jp Rd_Leave


;********************************************************************
;
; Procedure: D_Write
;
;  This procedure, like D_Read, allows the host to perform a single
;  write to the last seek address. KEEP IN MIND THAT THIS ROUTINE
;  WILL ALLOW YOU TO WRITE ANYWHERE ON THE DISK THAT YOU CARE TO
;  WRITE!!!!
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    ClrNormStat
;    Get_Wr_Data(D_Write_Response)
;    If not(Write_Common)
;      Then Data_Ex_Handler(Wr_Common.ErrorCode)
;    Rd_Leave
;  End
;
;********************************************************************

; Cmd F 0B Diag Write
D_Write		call L01ec
		call Get_SeqValue
		or DiskStat, #User_Type
		or DiskStat, #Wr_Op
		call RW_Common
		jr NZ, D_Write_End
		ld R0, #Error+Ex_Undetermined
		call Data_Ex_Handler
D_Write_End	jp Rd_Leave


;********************************************************************
;
; Procedure: Read_CStatus
;
;  This procedure allows the host to read the controller's status. 
;
;********************************************************************

; Cmd 5 01 Read Controller Status
Read_CStatus	ld R14, #(RBuffer1-6) /256	; RAM buffer 1013h
		ld R15, #(RBuffer1-6) #256
		ld R0, Status0
		ld R1, Status1
		ld R2, #0
		ld R3, #0
		ld R4, #0
		ld R5, #0
		ld R12, #Wrk_Sys
		ld R13, #6		; copy 6 bytes standard status 
Read_CStat_Lp1	ldei @RR14, @R12
		djnz R13, Read_CStat_Lp1
		ld R14, #RBuffer1 /256	; RAM buffer 1019h
		ld R15, #RBuffer1 #256
		ld R2, #014h
		ld R3, #07Bh
		call L0501
		ld R2, #014h
		ld R3, #07Fh
		call L0501
		ld R4, #Cylinder	; register 3A..3Dh
		call Read_CStat_Cp2
		ld R4, #Cur_Cyl		; register 38..3Bh
		call Read_CStat_Cp2
		ld R0, Excpt_Stat
		ld R1, DiskStat
		ld R2, 3Eh
		ld R3, RWStat
		call Read_CStat_Cp1	; system variables
		call L028e
		ld R3, R0
		ld R0, 5Dh
		ld R1, SlfTst_Result
		ld R2, P2
		call Read_CStat_Cp1	; more system variables
		ld R2, #LastSeek_Stat /256
		ld R3, #LastSeek_Stat #256
		call L0501		; last seek address
L167c		and 3Eh, #0FFh-010h-008h
		jp L114c
;
Read_CStat_Cp1	ld R4, #Wrk_Sys		; start at 10h
Read_CStat_Cp2	ld R5, #4		; copy four registers
Read_CStat_Lp2	ldei @RR14, @R4
		djnz R5, Read_CStat_Lp2
		ret    


;********************************************************************
;
; Procedure: Read_SStatus
;
;  This procedure is used by the host to examine the servo processor's
;  status information. The controller makes NO assumptions concerning
;  knowledge or meaning of the status bits, nor does the controller
;  interpret the status requests sent by the host. In other words,
;  when the host issues a request for status to the servo, it is
;  his responsibility to make certain that this request is meaningful
;
;  The returned status is preceded by Standard Status.
;
;********************************************************************

; Cmd 6 02 Send Servo Status
Read_SStatus	call Get_HostParms
		ld R2, #ServoStatus /256
		ld R3, #ServoStatus #256
		call Bank_Call
		call L1169
		ld R14, #RBuffer1 /256
		ld R15, #RBuffer1 #256
		ld R2, #SStatus0 /256
		ld R3, #SStatus0 #256
		call L0501
		jr L167c


; get host command parameters
Get_HostParms	srp #Wrk_Scr
	assume RP:Wrk_Scr
		ld R14, #(HostCmndBuf+1) /256	; first parameter
		ld R15, #(HostCmndBuf+1) #256
		ld R4, #Wrk_Sys			; into R0
		ld R5, #5			; copy five bytes
Get_HostP1	ldei @R4, @RR14
		djnz R5, Get_HostP1
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		ret   


;********************************************************************
;
; Procedure: Send_ServoCmnd
;
;  This procedure is used by the host to send the servo a command
;  of any type EXCEPT a status request (use Read_SStatus for that).
;  The controller will Abort the operation if this servo command
;  is sent to it.
;
;  Also, as in Read_SStatus, the host is responsible for the
;  command string that it sends to the servo - all the Widget
;  controller will do is pass along the command string.
;
;********************************************************************

; Cmd 7 03 Send Servo Command
Send_ServoCmnd	call Get_HostParms
		or R0, R0		; check for Status Command
		jr nz, S_Scmnd
		ld R15, #18
		jp Abort
S_Scmnd		ld R12, R0
		ld R13, R1
		ld R14, R2
		ld R15, R3
		ld R2, #ServoCmnd /256
		ld R3, #ServoCmnd #256
		call Bank_Call
		jp Rd_Leave


;********************************************************************
;
; Procedure: Send_Seek
;
;  This procedure allows the host to position the heads ANYWHERE
;  on the disk service that it pleases - the only consideration
;  is to be aware of the crash stop positions!
;
;  The form of the parameters passed into the controller are
;  HiCylinder, LowCylinder, Head, Sector. Keep in mind that these
;  values will be used to check for a valid header if and when
;  a state machine operation is initiated.
;
;********************************************************************

; Cmd 8 04 Send Seek
Send_Seek	call Get_HostParms	; get parameters from command processor
		or DiskStat, #Offset_On
		tm R4, #1		; auto offset on?
		jr NZ, Send_Sk1		;  no -->
		and DiskStat, #0FFh-Offset_On
Send_Sk1	ld R12, R0		; pass params to Seek
		ld R13, R1
		ld R14, R2
		ld R15, R3
		ld R2, #Seek /256
		ld R3, #Seek #256
		call Bank_Call
		jp Rd_Leave


;********************************************************************
;
; Procedure: Send_Restore
;
;  This procedure allows the host to issue either a Format Recal or
;  a Data Recal to the servo without having to build a primitive
;  servo command. The value of which type of restore is to be
;  performed is passed in with the command string.
;
;********************************************************************

; Cmd 9 05 Send Restore
Send_Restore	call Get_HostParms	; get recal type
		cp R0, #DataRecal	; Data Recal
		jr Z, S_Restore
		cp R0, #FrmtRecal	; Brake Release
		jr Z, S_Restore
		ld R15, #19
		jp Abort
S_Restore	ld R2, #Restore /256
		ld R3, #Restore #256
		call Bank_Call
		jp Rd_Leave


;********************************************************************
;
; Procedure: Set_Recovery
;
;  This procedure is used by the host to set the global
;  variable Recovery either on or off. This variable controls
;  the behaviour of Widget when an exception occurs; in the
;  case of Recovery = true, the controller tries everything it
;  can to correct the exception and continue about it's day.
;  When Recovery = false, however, the controller will do nothing
;  about the problem and report the error to the host.
;
;********************************************************************

; Cmd A 06 Set Recovery
Set_Recovery	call Get_HostParms
		and 3Eh, #0FFh-004h
		and Excpt_Stat, #0FFh-Buf_Damage
		tm R0, #2		; ??? when bit 1 set
		jr Z, L1721
		or 3Eh, #004h
L1721		and Excpt_Stat, #0FFh-Recovery
		tm R0, #1		; turn on recovery when bit 0 set 
		jr Z, L172c
		or Excpt_Stat, #Recovery
L172c		tm R0, #4		; ??? when bit 2 set
		jr NZ, L1734
		or Excpt_Stat, #Buf_Damage	; ???
L1734		jp Rd_Leave


;********************************************************************
;
; Procedure: Send_Park
;
;  This diagnostic command allows the host to issue a Park
;  command to the drive. This command has the effect of
;  sending the drive heads off the data surface.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    ClrNormStat
;    Ack_Read(S_Park_Response)
;    Park_Heads
;    Rd_Leave
;  End
;
;********************************************************************

; Cmd C 08 Send Park
Send_Park	ld R2, #Park_Heads /256
		ld R3, #Park_Heads #256
		call Bank_Call
		jp Rd_Leave


;********************************************************************
;
; Procedure: Set_AutoOffset
;
;  This command allows the user to set the auto offset capabilities
;  of the drive without using the Servo Command function.
;
; Inputs: {none}
;
; Outputs: {none}
;
; Algorithm:
;
;  BEGIN
;    Auto_Offset
;  END
;
;********************************************************************

; Cmd 10 0C Auto Offset
Set_AutoOffset	ld R2, #Auto_Offset /256
		ld R3, #Auto_Offset #256
		call Bank_Call
		jp Rd_Leave


;********************************************************************
;
; Procedure: Wr_SprTbl
;
;  This command allows the host to update the spare table
;  without the controller's intervention. BE CAREFUL WITH
;  THIS ONE!
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    If not(Chk_PassWord(CommandString#1)) Then Abort
;    Ack_Read(Wr_Spr_Response)
;    Clr_Bsy(SpareArray)
;  End
;
;********************************************************************

; Cmd 12 0E Write Spare Table
Wr_SprTbl 	call L01ec
		ld R0, #(HostCmndBuf+1) /256
		ld R1, #(HostCmndBuf+1) #256
		ld R2, #Chk_PassWord /256
		ld R3, #Chk_PassWord #256
		call Bank_Call
		jr NZ, Wr_Spr1
		ld R15, #20
		jp Abort
;
Wr_Spr1		ld R2, #WrBuf_To_Spr /256
		ld R3, #WrBuf_To_Spr #256
		call Bank_Call
		ld R2, #UpDate_SprTbl /256
		ld R3, #UpDate_SprTbl #256
		call Bank_Call
		jp Rd_Leave


;********************************************************************
;
; Procedure: Format
;
;  This procedure allows the host to format the track that the heads
;  are currently positioned over.
;
;  BE ULTRA CAREFUL HERE!!!! THIS COMMAND DESTROYS ALL DATA ON THE
;  TRACK.... DATA RECOVERY WILL BE IMPOSSIBLE AFTER A TRACK HAS BEEN
;  FORMATTED.
;
;  The two parameters that are passed into the controller by the host
;  allow the host to specify the offset from index mark (in sectors)
;  that Sector 0 will be located and the interleave factor.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    ClrNormStat
;    If not(Chk_PassWord(CStatus4+3)) Then Abort
;    Ack_Read(Fmt_Response)
;    If not(FormatTrack(CStatus4+1, CStatus4+2)
;      Then Abort
;    Rd_Leave
;  End
;
;********************************************************************

Format		call Chk_FmtParms
		push Sector
		ld R2, #FormatTrack /256
		ld R3, #FormatTrack #256
		call Bank_Call
		pop Sector
		jp Rd_Leave

Chk_FmtParms	ld R0, #(HostCmndBuf+1) /256
		ld R1, #(HostCmndBuf+1) #256
		ld R2, #Chk_PassWord /256
		ld R3, #Chk_PassWord #256
		call Bank_Call
		jr NZ, Format1
		ld R15, #21
		jp Abort
Format1		ret    


;********************************************************************
;
; Procedure: Read_Abort
;
;  This command allows the host to get a snapshot of the controller's
;  register set a the time of the last abort. If there has been no
;  abort, the results of this command will be invalid.
;
; Inputs: none
;
; Outputs: none
;
;********************************************************************
                   
Read_Abort	ld R0, #Abort_Stat /256
		ld R1, #Abort_Stat #256
		ld R2, #RBuffer1 /256
		ld R3, #RBuffer1 #256
		ld R4, #0		; copy 256 bytes
Rd_Abt_Lp	lde R5, @RR0
		lde @RR2, R5
		incw RR0
		incw RR2
		djnz R4, Rd_Abt_Lp
		jp Rd_Leave


;********************************************************************
;
; Procedure: D_RstSrvo
;
;  This procedure allows the host to reset the servo processor.
;
; Inputs: none
;
; Outputs: none
;
;********************************************************************

D_RstSrvo	ld R2, #ResetServo /256
		ld R3, #ResetServo #256
		call Bank_Call
		jp Rd_Leave


; Cmd 18 14 Write Track (all sectors with the same data)
D_WrTrack	or DiskStat, #Wr_Op+User_Type
		jp D_RdTrk1


; Cmd 17 13 Read Track
D_RdTrack	or DiskStat, #User_Type
		and DiskStat, #0FFh-Wr_Op
D_RdTrk1	call Get_SeqValue
D_RdTrk_Next	call RW_Common
		jr Z, D_RdTrk_Err
		add Sector, #2		; use 2:1 interleave
		cp Sector, #NbrSctrs
		jr LT, D_RdTrk_Next
		cp Sector, #NbrSctrs+1		
		jr Z, D_RdTrk_Done
		ld Sector, #1
		jr D_RdTrk_Next
;
D_RdTrk_Err	ld R0, #Error+Ex_Undetermined
		call Data_Ex_Handler
D_RdTrk_Done	jp Rd_Leave


; Cmd 19
L17e4		ld R2, #L2E44 /256
		ld R3, #L2E44 #256
		call Bank_Call
		jp Rd_Leave


; Cmd 20
L17ee		ld R2, #L2E4E /256
		ld R3, #L2E4E #256
		call Bank_Call
		jp Rd_Leave



;********************************************************************
; Module Cmnd2.Assem  {continuation of the command processor module}
;
; This module contains all the code associated with processing
; the System commands.
;
;	PROCEDURE Sys_Read
;	PROCEDURE Sys_Write
;
;********************************************************************

;********************************************************************
;
; Procedure: Sys_Read
;
;  This procedure is the System Read command for Widget. It allows
;  the host to read up to 8 sequential blocks without sending any
;  additional commands. Between each block status is passed back to
;  the host with the data, and the host must set CMD before the next
;  block can be read. In general, the protocol is about the same as
;  in Pro_Read.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    Ld_LgclBlk(Wid_Log_Offset)
;    Count:=Ld_Param1.FirstParam
;    Offset:=0
;    BlockNumber:=Load_Logical
;    ClrNormStat
;    Get_Type_Check(BlockNumber+Count)
;    Seek_Type:=Access
;    DiskStat.Wr_Op:=false
;    OverLap
;    If not(ReadBlock)
;      Then
;        SS_RdErr
;        Goto Pro_Rd_Exit
;    While Always Do
;      BlockNumber:=BlockNumber+1
;      If not(SrchCache)
;        Then OverLap
;      If not(Read_Fast)
;        Then Goto Pro_Rd_Exit
;      If Count>1
;        Then
;          Command_Pending, IBsy:=true, Response:=Sys_Rd_Resp
;          Rd_Leave2
;        Else RdLeave
;      Count:=Count-1
;  End
;
;********************************************************************

; Cmd 0 System Read Block
Sys_Read	call Sys_SetUp		; Sys_SetUp ???
Sys_Rd_Lp	and DiskStat, #0FFh-Wr_Op-Offset_On
		or DiskStat, #User_Type
		call Sys_Rw_Seek		; Sys_RW_Seek ???
		and DiskStat, #0FFh-Wr_Op
		call RW_Common
		jr Z, Sys_RdErr
;
		tm 3Eh, #B_Block	; check if bad block came back!
		jr NZ, Sys_Rd_BB
		or 3Eh, #010h+008h
		djnz R4, Sys_Rd_More
		jp Rd_Leave
Sys_Rd_More	call L0198
Sys_Rd_M2	call Sys_Inc_Blk
		jr Sys_Rd_Lp
;
Sys_RdErr	call Data_Ex_Handler
		jr Sys_Chk_Ftl
;
Sys_Rd_BB	call Pro_Rd_BB		; mark block for sparing and set Z flag
		jr Sys_RdErr

Sys_Chk_Ftl	call Chk_FatalStat
		jp NZ, Rd_Leave		; get out if fatal error
		or 3Eh, #010h+008h
		djnz R4, Sys_Rd_M1
		jp Rd_Leave
Sys_Rd_M1	call L114c
		ld R1, #4
		ld R2, #014h
		ld R3, #07Bh
		call L0450
		call Load_Logical
		jr Sys_Rd_M2
;
Chk_FatalStat	tm Excpt_Stat, #Buf_Damage	; check if operation failed
		jr NZ, Chk_FatStat1
		ld R2, #014h
		ld R3, #07Bh
		lde R0, @RR2		; get 1st byte of standard stat ???
		tm R0, #1		; check if operation failed
Chk_FatStat1	ret    
;
Sys_SetUp	ld R2, #010h
		ld R3, #020h
		lde R0, @RR2
		cp R0,>5Dh
		jp NZ, Abort_61
		call Get_HostParms
		or R0, R0		; check for zero count
		jp Z, Abort_24
		ld R4, R0		; Count:=...
		ld >Status1, R0		; remember block count
		dec R4			; account for numbering 1..n
		ld R2, #(HostCmndBuf+2) /256
		ld R3, #(HostCmndBuf+2) #256
		ld R14, #LogicalBlock /256
		ld R15, #LogicalBlock #256
		ld R10, #Wrk_Sys+12
		ld R1, #3
Sys_Set1	lde R0, @RR2		; copy LBA from host command
		lde @RR14, R0		; into LogicalBlock and
		ld @R10, R0		; R12..14
		inc R10
		incw RR2
		incw RR14
		djnz R1, Sys_Set1
		add R14, R4		; set R12..14 to last block to read
		adc R13, #0
		ld R0, #HiMaxLogical
		ld R1, #MidMaxLogical
		ld R2, #LoMaxLogical
		call L0459
		jr NC, Sys_Set2
;
		ld R0, #002h		; LBA overflow, abort
		ld R1, #040h
		call L029b
		ld R15, #28
		jp Abort
;
Sys_Set2	sub R14, R4		; restore first block to read
		sbc R13, #0
		or DiskStat, #User_Type
		ld 0Ch, #WBuffer1 /256
		ld 0Dh, #WBuffer1 #256
		inc R4			; and get ready for next one
		ret    
;
Sys_Rw_Seek	push R4			; save state
		ld R2, #OverLap /256
		ld R3, #OverLap #256
		call Bank_Call
		pop R4
		tm DiskStat, #Wr_Op	; no auto-offset when reading
		jr Z, Sys_Rw_Sk1
		tm DiskStat, #Offset_Set	; or offset already set
		jr NZ, Sys_Rw_Sk1
		ld R2, #ReSeek /256
		ld R3, #ReSeek #256
		call Bank_Call
Sys_Rw_Sk1	ld R2, #LogicalBlock /256
		ld R3, #LogicalBlock #256
		ld R1, #3
		ld R0, #Wrk_Sys+12
Sys_Rw_Sk_Lp	ldei @R0, @RR2		; get block number into R12..14
		djnz R1, Sys_Rw_Sk_Lp
		ret    
;
Sys_Inc_Blk	add R14, #1		; BlockNumber:=BlockNumber+1
		adc R13, #0
		adc R12, #0
		ld R2, #LogicalBlock /256
		ld R3, #LogicalBlock #256
		ld R1, #3
		ld R0, #Wrk_Sys+12
Sys_Inc_Lp	ldei @RR2, @R0
		djnz R1, Sys_Inc_Lp
		dec Status1
		ret    
;
Abort_24	ld R15, #24
		jp Abort
;
Abort_55	ld R15, #55
		jp Abort

Abort_61	ld R15, #61
		jp Abort


;********************************************************************
;
; Procedure: Sys_Write
;
;  This procedure is the System Write command for Widget. In general
;  it is a major departure from the ProFile write protocol: Status is
;  not sent back to the host unless there is useful information in
;  the status -- the fact that there were no errors in a block
;  transfer is communicated to the host via Response Byte that is
;  handshaken across at CMD/BSY time. If an error has occurred, then
;  the host is to recognize this state and come back to read the
;  status from the controller, otherwise it is assumed that the next
;  thing that the controller wants is write data. Note that the
;  second handshake (data received acknowledgement) has been removed
;  from the protocol.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    Ld_LgclBlk(Wid_Log_Offset)
;    Count:=Ld_Param1.FirstParam
;    BlockNumber:=Load_Logical
;    ClrNormStat
;    Get_Type_Check(BlockNumber+Count)
;    Seek_Type:=Access_Offset
;    DiskStat.Wr_Op:=true
;    OverLap
;    If not(ReadBlock)
;      Then
;        SS_RdErr
;        Goto Pro_Rd_Exit
;    While Always Do
;      BlockNumber:=BlockNumber+1
;      If not(SrchCache)
;        Then OverLap
;      If not(Write_Common)
;        Then Data_Ex_Handler(Wr_Common.Error.Code)
;      If not(Read_Fast)
;        Then Goto Pro_Rd_Exit
;        Else
;          If BlkStat.Bad_Block
;            Then Goto Pro_Rd_BB
;      If Count>1
;        Then
;          Command_Pending, IBsy:=true, Response:=Sys_Wr_Resp
;          Rd_Leave2
;        Else RdLeave
;      Count:=Count-1
;  End
;
;********************************************************************

; Cmd 1 System Write Block
Sys_Write	call Sys_SetUp
Sys_Wr_Lp	or DiskStat, #Wr_Op+Offset_On+User_Type
		call Sys_Rw_Seek
		tm 3Eh, #B_Block	; check if bad block
		jp NZ, Sys_Wr_BB
		or DiskStat, #Wr_Op+Offset_On+User_Type
		call RW_Common
		jr Z, Sys_WrErr
;
		or 3Eh, #010h+008h+002h
		djnz R4, Sys_Wr_Next	; more to do?
Sys_WrE1	jp Rd_Leave
Sys_Wr_Next	ld 06h, #0EFh
		call L0198
Sys_Wr_M1	cp R0, R4
		jp NZ, Abort_56
		cp R1,>5Dh
		jp NZ, Abort_61a
		call Sys_Inc_Blk
		jr Sys_Wr_Lp
;
Sys_WrErr	call Data_Ex_Handler
Sys_WrChk	call Chk_FatalStat
		jr NZ, Sys_WrE1
		or 3Eh, #010h+008h+002h
		djnz R4, Sys_Wr_More
		jp Sys_WrE1
Sys_Wr_More	ld 06h, #0EFh
		call L0198
		ld R0, #0
		ld R1, #4
		ld R2, #014h
		ld R3, #07Bh
		call L0450
		call Load_Logical
		jr Sys_Wr_M1
;
Sys_Wr_BB	call Wr_BBlock
		jr Sys_WrChk
;
Abort_56	ld R15, #56
		jp Abort
;
Abort_61a	ld R15, #61
		jp Abort


; Cmd 2 System WriteVerify Block
Sys_WrVer	call Sys_SetUp
Sys_WV_Lp	or DiskStat, #Wr_Op+Offset_On+User_Type
		call Sys_Rw_Seek
		tm 3Eh, #B_Block	; check if bad block
		jr Z, Sys_WVErr
		call Wr_BBlock
		jr Sys_WVChk
;
Sys_WVErr	call WrVer_Common
Sys_WVChk	call Chk_FatalStat
		jr NZ, Sys_WrE1
		or 3Eh, #010h+008h+002h
		djnz R4, Sys_WV_More
		jp Rd_Leave
Sys_WV_M1	call Sys_Inc_Blk
		jr Sys_WV_Lp
;
Sys_WV_More	ld 06h, #0EFh
		call L0198
		cp R0, R4
		jr NZ, Abort_56
		cp R1,>5Dh
		jr NZ, Abort_61a
		ld R0, #0
		ld R1, #4
		ld R2, #014h
		ld R3, #07Bh
		call L0450
		call Load_Logical
		jr Sys_WV_M1



;********************************************************************
; Module Write.Assem
;
;  This module contains all but the very most primitive of procedures
;  (the routines that are resident are listed in the external spec's)
;  that concern themselves with performing a write operation.
;
;	FUNCTION WriteBlock( Parent : BYTE {R8} ) :
;		BOOLEAN
;		Status : BYTE {R0}
;		WrErrCnt : BYTE {R1}
;
;********************************************************************

;********************************************************************
;
; Function: WriteBlock
;
;  This function assumes that the heads are positioned over the
;  correct track and writes the block of data whose header matches
;  the header that is made up of the cylinder, head and sector
;  information that is stored in memory.
;
; Inputs: Parent : BYTE {R8}
;
; Outputs: WriteBlock : BOOLEAN {Zero flag, true if error in ReadBlock}
;          Status     : BYTE {R0}
;          WrErrCnt   : BYTE {R1}
;
; Global Variables Used: Cylinder, Head, Sector, Recovery
;
; Local Variables Used: WrRetryCnt : BYTE {R8}
;                       WrError    : BOOLEAN {R9/bit 7}
;                       WrExcept   : BOOLEAN {R9/bit 6}
;                       WrSuccess  : BOOLEAN {R9/bit 5}
;                       NoHeaderFound : BOOLEAN {R9/bit 4}
;                       SectorsRead: BYTE {R10}
;
; Algorithm:
;
;  BEGIN
;    SetDeadManTimer( WriteBlock, Parent )
;    WrRetryCnt := 10
;    WrErrCnt := 0
;    WrError := False
;    WrExcept := False
;    NoHeaderFound := False
;    REPEAT
;      WHeader[ 1 ] := HiCylinder
;      WHeader[ 2 ] := LoCylinder
;      WHeader[ 3 ]/bits 7:6 := Head
;      WHeader[ 3 ]/bits 5:0 := Sector
;      WHeader[ 4 ] := Invert( WHeader[ 1 ] )
;      WHeader[ 5 ] := Invert( WHeader[ 2 ] )
;      WHeader[ 6 ] := Invert( WHeader[ 3 ] )
;      WDataSync := $0001
;     _
;    /
; R  |  Set-up external ram address counter for WRITE
; E  |  Msel0:1 := Disk <--> Mem
; S  |  WHILE SectorMark DO BEGIN END
; I  |  StartL := True
; D  |  WHILE NOT( SectorDnL ) DO BEGIN END
; E  |  Status := Status_Port
; N  |  StartL := False
; T  |  Msel0:1 := Z8 <--> Mem
;    \_
;
;      CASE Status.State OF
;        NormalEndState        : RWStat.WrSuccessful := True
;
;        NoMatchingHeaderFound : RWStat.WrSuccessful := False
;                                RWStat.WrError := True
;                                RWStat.NoHeaderFound := True
;
;        AbnormalState         : Reset_StateMachine
;                                Abort
;
;      IF Status.ServoErr OR NOT( Status.ServoRdy )
;        THEN
;          RWStat.WrError := True
;          RWStat.Except := True
;
;      IF Status.WrtNvldL  AND WrSuccessful
;        THEN
;          RWStat.WrError := True
;          RWStat.WrErrCnt := WrErrCnt + 1
;          WrRetryCnt := WrRetryCnt - 1
;        ELSE
;          RdRetryCnt := 0
;
;    UNTIL NOT( Recovery ) OR NOT( WrError ) OR ( WrRetryCnt = 0 ) OR
;               WrExcept OR ( NoHeaderFound )
;    ClearDeadManTimer
;  END
;
;********************************************************************

WriteBlock	clr RWStat		; clear booleans
		ld R8, #10		; WrdRetryCnt:=10
		clr R9			; ErrCnt:=0
		or DiskStat, #Wr_Op	; make certain we are writing
;
WrBlk_Rpt	ld R2, #WHeader /256	; initialize gaps
		ld R3, #WHeader #256
		call Load_Header
;
		ld R0, #0
		ld R1, #(WDataSync - WDataGap - 1)
WrGap_Lp	lde @RR2, R0		; write 13x $00
		inc R3
		djnz R1, WrGap_Lp
;
		ld R0, #0		; assume $00 for Nisha
		tm 3Eh, #HDA_Type	; do we have a Nisha HDA?
		jr Z, L19db		;  yes -->
		ld R0, #0FFh		;  else use $FF for Rodime
L19db		lde @RR2, R0	
		inc R3
		ld R0, #1
		lde @RR2, R0		; then first byte of sync
		inc R3
		ld R0, #055h		; then second byte of sync
		lde @RR2, R0
		call L0489		; ??? generate header ???
		call L01ff		; ??? Wr_Resident ???
		or R10, R10
		jr Z, WrBlk_NoHdr
		ld R1, R5		; CASE Status.State
		and R1, #YMask
		cp R1, #Norm_State 	; statemachine healthy?
		jr NZ, WrBlk_Abnorm
;
WrBlk_Norm	tm R5, #ServoErr	; IF ServorErr OR NOT(ServoRdy)
		jr NZ, WrBlk_ServoErr
		tm R5, #ServoRdy
		jr Z, WrBlk_ServoErr
Wr_ServoOk	tm >15h, #WrtNvldL	; IF Status.WrtNtVldL (ECC error)?
		jr Z, WrBlk_NVld

		and RWStat, #0FFh-WrError
WrBlk_Until	tm Excpt_Stat, #Recovery
		jr Z, WrBlk_End
		tm RWStat, #WrError
		jr Z, WrBlk_End
		djnz R8, WrBlk_Rpt1	; try again if fault occurred
;
WrBlk_End	tcm RWStat, #WrError	; set zero flag if error
		ret   
;
WrBlk_Rpt1	call ZeroHeader		; clear up header
		jr WrBlk_Rpt		; and try again
;
WrBlk_Abnorm	call Reset_StMach
		or RWStat, #WrError+WrSMErr
		ld R9, #010h
		or R9, R1
		jr WrBlk_End
;
WrBlk_NoHdr	tm R5, #ServoErr
		jr NZ, WrBlk_ServoErr
		tm R5, #ServoRdy
		jr Z, WrBlk_ServoErr
		or RWStat, #WrError+WrNoHdrFnd
		or R9, #020h
		jr WrBlk_End

WrBlk_ServoErr	or RWStat, #WrError+WrSrvoErr	; THEN WrError AND WrSrvoErr
		jr WrBlk_End
;
WrBlk_NVld	or RWStat, #WrError		;  ELSE
		inc R9
		jr WrBlk_Until



;********************************************************************
; Module Read.Assem
;
; This module contains all but the very most primitive of
; procedures (the routines that are resident are listed
; in the external spec's) that concern themselves with performing
; a read operation.
;
;	FUNCTION ReadBlock( Parent : BYTE {R8} ) :
;		BOOLEAN
;		Status : BYTE {R0}
;		 RdErrCnt : BYTE {R1}
;
;********************************************************************

;********************************************************************
;
; Function: ReadBlock
;
;  This function assumes that the heads are positioned over the 
;  correct track and reads the block of data whose header matched
;  the header that is made up of the cylinder, head and sector
;  information that is stored in memory.
;
; Inputs: Parent: BYTE {R8}
;
; Outputs: ReadBlock: BOOLEAN {zero flag, true if error in ReadBlock}
;          Status:    BYTE {R0}
;          RdErrCnt:  BYTE {R1}
;
; Global Variables Used: Cylinder, Head, Sector, Recovery
;
; Local Variables Used: RdRetryCnt:  BYTE {R8}
;                       RdError:     BOOLEAN {R9/bit 7}
;                       RdExcept:    BOOLEAN {R9/bit 6}
;                       RdSuccess:   BOOLEAN {R9/bit 5}
;                       SectorsRead: BOOLEAN {R9/bit 4}
;
; Algorithm:
;
;  Begin
;    SetDeadManTimer(ReadBlock, Parent)
;    RdRetryCnt:=10
;    RdErrCnt:=0
;    RdError:=false
;    RdExcept:=false
;    NoHeaderFound:=false
;    SectorsRead:=2xNbrSctrs {try to find header for two rotations}
;    Repeat
;      RHeader[1]:=HiCylinder
;      RHeader[2]:=LoCylinder
;      RHeader[3]/bits 7:6:=Head
;      RHeader[3]/bits 5:0:=Sector
;      RHeader[4]:=invert(RHeader[1])
;      RHeader[5]:=invert(RHeader[2])
;      RHeader[6]:=invert(RHeader[3])
;      ReadArray[RDummy-1]:=0
;    /-
;  R | Set-up external RAM address counter for read
;  E | Msel0:1:=Disk<-->Mem
;  S | While SectorMark Do Begin End
;  I | StartL:=true
;  D | While not(SectorDnL) Do Begin End
;  E | Status:=StatusPort
;  N | StartL:=false
;  T | Msel0:1:=Z8<-->Mem
;    \-
;     Case Status.State Of
;       NormalEndState:        RdSuccess:=true
;       NoMatchingHeaderFound: RdSuccess:=false
;                              RdError:=true
;                              NoHeaderFound:=true
;       AbnormalState:         Reset_StateMachine
;                              Abort
;     If Status.ServoErr Or not(Status.ServoRdy)
;       Then
;         RdError:=true
;         RdExcept:=true
;     If Status.CrcErr And RdSuccess
;       Then
;         RdError:=true
;         RdErrCnt:=RdErrCnt+1
;         RdRetryCnt:=RdRetryCnt-1
;       Else
;         If RdError
;           Then
;             BlockMove(Buffer2, RBuffer1)
;             RdRetryCnt:=RdRetryCnt-1
;    Until not(Recovery) Or not(RdError) Or RdRetryCnt=0 Or
;           RdExcept Or NoHeaderFound
;    ClearDeadManTimer
;    Status:=R9
;  End
;
;********************************************************************

ReadBlock	clr RWStat		; clear booleans
		ld R8, #10		; RdRetryCnt:=10
		clr R9			; ErrCnt:=0
		and DiskStat, #0FFh-Wr_Op	; make sure we are reading
RdBlk_Rpt	ld R2, #RHeader /256	; initialize gaps
		ld R3, #RHeader #256
		call Load_Header
		ld R0, #0
		lde @RR2, R0
		ld R2, #(RDummy-1) /256
		ld R3, #(RDummy-1) #256
		lde @RR2, R0
		incw RR2
		lde @RR2, R0
		call L04a3
		call L0201
		or R10, R10
		jr Z, RdBlk_NoHdr
		ld R1,>15h		; R5
		and R1, #YMask
		cp R1, #Norm_State
		jr NZ, RdBlk_AbNorm
;
RdBlk_Norm	tm R5, #ServoErr	; If ServoErr Or not(ServoRdy)
		jr NZ, RD_ServoErr
		tm R5, #ServoRdy
		jr Z, RD_ServoErr
;
		tm R5, #CrcErrL		; If Status.CrcErr
		jp Z, RD_BadCrc
		tm RWStat, #RdError
		jp NZ, RdBlk_Rmove
RdBlk_Until	tm Excpt_Stat, #Recovery
		jr Z, RdBlk_End
		tm RWStat, #RdError
		jr NZ, RdB_Rpt1
;
RdBlk_End	tcm RWStat, #RdError	; set zero flag if error
		ret  
; 
RdB_Rpt1	call ZeroHeader
		jr RdBlk_Rpt
;
RdBlk_AbNorm	call Reset_StMach
		or RWStat, #RdError+RdSMErr
		ld R9, #010h
		or R9, R1
		jr RdBlk_End
;
RdBlk_NoHdr	tm R5, #ServoErr
		jr NZ, RD_ServoErr
		tm R5, #ServoRdy
		jr Z, RD_ServoErr
		or RWStat, #RdError
		tm >19h, #Hdr_MisMatch		; R9
		jr NZ, Rd_HdrErr
		or >19h, #Hdr_MisMatch
		tm Excpt_Stat, #Recovery	; auto offset ONLY if recovery on
		jr Z, RdBlk_Until
		ld R2, #ReSeek /256		; set auto-offset
		ld R3, #ReSeek #256
		call Bank_Call
		jr RdBlk_Until
;
Rd_HdrErr	or RWStat, #RdError+RdNoHdrFnd
		jr RdBlk_End
;
RD_ServoErr	or RWStat, #RdError+RdSrvoErr	; Then RdError And RdServoErr
		jr RdBlk_End
;
RD_BadCrc	or RWStat, #RdError+RdCrcErr	; Else
		inc R9
		or R9, #EccStat
		tm Excpt_Stat, #Recovery	; re-seek only if recovery is on
		jr Z, Rd_B_Crc_1
		tm DiskStat, #Offset_Set		; set auto-offset if needed
		jr NZ, Rd_B_Crc_1
		ld R2, #ReSeek /256
		ld R3, #ReSeek #256
		call Bank_Call
Rd_B_Crc_1	djnz R8, RdBlk_Until
		jr RdBlk_End
;
RdBlk_Rmove	ld R2, #RBuf_To_Buf2 /256
		ld R3, #RBuf_To_Buf2 #256
		call Bank_Call
		jr Rd_B_Crc_1



;********************************************************************
; Module Cache.Assem
;
; This name of this module is a bit misleading: there is no true
; cache implemented at this time. However, there is an attempt made
; at some primitive look-ahead methods to reduce the access time
; of the disk. This module contains those routines that are
; chiefly involved with the look-ahead algorithm.
;
;	FUNCTION CnvrtLogical(LogicalBlock : 3 BYTES {R12:14}) :
;		CnvrtLogical : BOOLEAN {true if block spared}
;		Cylinder : WORD {RR12}
;		Head : BYTE {R14}
;		Sector : BYTE {R15}
;		Status : BYTE {R0}
;		Ptr : BYTE {R1}
;	FUNCTION SrchCach(LogicalBlock : 3 BYTES {R12:14}
;		Random : BOOLEAN {R7/Bit 7}
;		Offset : 3 BITS {R7/Bits 2:0}) :
;		BOOLEAN
;		HeadSector : BYTE {R0}
;
;********************************************************************

;********************************************************************
;
; Function: CnvrtLogical  {convert logical block}
;
;  This function is responsible for converting a logical block
;  number to a physical block number by first searching the spare
;  table and then doing the appropriate arithmetic to arrive at
;  the cylinder, head, and sector value.
;
; Inputs: LogicalBlockNumber: 3 BYTES {R12:14}
;
; Outputs: Cylinder: WORD {R12:13}
;          Head:     BYTE {R14}
;          Sector:   BYTE {R15}
;          Status:   BYTE {R0, returned from search spare table}
;          Ptr:      BYTE {R1, returned from search spare table}
;
; Local Variables: PhysicalBlock: 3 BYTES {R12:14}
;                  Temp:          3 BYTES {R1:3}
;
; Algorithm:
;
;  Begin
;    If LogicalBlock>MaxLogicalBlock Then Abort
;    PhysicalBlock:=SearchSpareTable(LogicalBlock)
;    Cylinder:=PhysicalBlock div (Heads*Sectors)
;    Temp:=PhysicalBlock mod (Heads*Sectors)
;    Head:=Temp div Sectors
;    Sector:=Temp mod Sectors
;  End
;
;********************************************************************

CnvrtLogical	call L02ab
;
; *** SrchSpTabl function inline
;  This procedure is responsible for checking to see if the block number
;  that is passed into it is currently in the spare table. If the block
;  is found to be in the spare table then the physical block number of
;  the spare block is passed back to the caller, as well as the PTR to
;  the location of spared block's element within the spare table. In any
;  case, a byte of status is always passed back to the caller describing
;  the state of the logical block within the spare table.
;
; Inputs: LogicalBlockNumber: 3 BYTES {R12:14}
;         ElementType:        BYTE {R15}
;
; Outputs: CnvrtLogical:  BOOLEAN {zero flag set if not found in table}
;          PhysicalBlockNumber: 3 BYTES {R12:14}
;          Status:              BYTE {ScrReg0}
;          ElementPtr:          BYTE {ScrReg1}
;
		clr R7			; Found:=false
; *** Get_HeadPtr function inline
		ld R1, R13		; check if head ptr is NIL
		and R1, #0FCh		; but first form a headptr structure
		rr R1			; and index into HdPtr array
		rr R1
		ld R2, #SegPtrArray /256
		ld R3, #SegPtrArray #256
		add R3, R1
		adc R2, #0
		lde R0, @RR2		; get HeadPtr and check for NIL
		tcm R0, #Nil
		jp Z, NotInTabl		; do a real search if not NIL
;
SrchLp		cp R0, #304/4		; pointer out of range? 
		jp LT, SST_GetPtr
		ld R15, #50
		jp Abort
; *** Get_Ptr function inline
SST_GetPtr	ld ScrReg1, R0		; save current ptr
		ld R2, #SpareTable /256
		ld R3, #SpareTable #256
		ld R1, R0
		clr R0
		add R1, R1		;  RR0 := 4 * R1
		add R1, R1
		adc R0, #0
		add R3, R1		; add offset into table
		adc R2, R0
		lde R1, @RR2		; get element status
		ld ScrReg0, R1		; save element status
		tm R1, #Useable		; If Useable
		jr Z, SrchLpElse
		tm DiskStat, #User_Type
		jr Z, SST_GetPtr1	; no user block, set spare table type
		ld R0, #UserBlk_Type
		jr SST_GetPtr2
SST_GetPtr1	ld R0, #SprTbl_Type
SST_GetPtr2	tm R1, R0		; And Type is correct
		jr Z, SrchLpElse
		incw RR2
		lde R0, @RR2		; get token
		incw RR2
		lde R1, @RR2
		cp R1, R14		; check bits 0:7 first
		jr NZ, SrchLpElse
		and R0, #3
		ld R1, R13
		and R1, #3
		cp R0, R1		; then bits 8:9
		jr NZ, SrchLpElse
		tm ScrReg0, #Spare	; check if BadBlock
		jr NZ, Srch_Spare
		or R7, #Found
		jr NotInTabl
;
Srch_Spare	ld R0, ScrReg1		; get back pointer
		inc R0			; number of spare blocks 1..76
; ***** INLINE: MulR0_m *****
MulR0_m		clr R14			; Result:= R0 * 256
		ld R13, R0
		clr R12
		rlc R14			; Result := Result * 2
		rlc R13
; ***************************
		or R7, #Found
		jr Get_Cyl_H_S
;
SrchLpElse	tm ScrReg0, #Nil	; test if element.Ptr=Nil
		jr NZ, NotInTabl
;
		ld R0, ScrReg1		; get address of current element
		call Get_Ptr
		add R3, #3		; point to next Ptr
		adc R2, #0
		lde R0, @RR2
		jr SrchLp

NotInTabl	ld R2, R13		; shift right 1 byte
		rcf    
		rrc R2
		add R14, R2		; PhysicalBlock:=LogicalBlock +
		adc R13, #0		;              LogicalBlock DIV k
		ld R0, R13		; save rollover byte
		and R0, #0FEh		; mask off MOD 512 bits
		rl R2
		cp R0, R2		; check for rollover
		jr Z, Get_Cyl_H_S
		add R14, #1		; otherwise account for rollover
		adc R13, #0
;
; *** Get_Cyl_H_S function inline
;  This routine extracts the cylinder, head, and sector information
;  from a physical block number.
;
; Inputs: PhysicalBlockNumber: 3 BYTES {R12:14}
;
; Outputs: HiCylinder: BYTE {R12}
;          LoCylinder: BYTE {R13}
;          Head:       BYTE {R14}
;          Sector:     BYTE {R15}
;
Get_Cyl_H_S	ld R0, R13		; physical LBA
		ld R1, R14
		rcf    			; calculate cylinder number
		rrc R0			; /(32 sectors * 2 heads)
		rrc R1
		rrc R0
		rrc R1
		rrc R0
		rrc R1
		rrc R0
		rrc R1
		rrc R0
		rrc R1
		rrc R0
		rrc R1
		tm 3Eh, #HDA_Type	; Nisha HDA?
		jr Z, Get_CHS1		;  yes --> done
		rrc R0			; otherwise /(32 sectors * 4 heads)
		rrc R1
Get_CHS1	and R0, #3		; clip HiCyl 
		ld R15, R14
		and R15, #NbrSctrs-1	; get sector
		ld R2, R14	
		ld R14, #0		; set head 0
		and R2, #(NbrHds_A*NbrSctrs)-1	; Rodime values
		tm 3Eh, #HDA_Type	; Nisha HDA?
		jr NZ, Get_CHS2		;  no --> 
		and R2, #(NbrHds_B*NbrSctrs)-1	; Nisha values
Get_CHS2	tm R2, #020h		; head 1 ?
		jr Z, Get_CHS3
		or R14, #001h		; set Hs0 bit
Get_CHS3	tm R2, #040h		; head 2 or 3 ?
		jr Z, Get_CHS4
		or R14, #002h		; set Hs1 bit
Get_CHS4	ld R13, R1		; HiCyl
		ld R12, R0		; LoCyl
		ld R2, #Map_Table /256
		ld R3, #Map_Table #256
		add R3, R15		; index into interleave table
		adc R2, #0
		lde R15, @RR2		; get remapped sector
		di     
		or R7, R7		; set zero flag if not found in spare table
		ld R0, ScrReg0		; Search Status
		ld R1, ScrReg1		; Element.Ptr
		jp Bank_Ret


;********************************************************************
;
; Function: OverLap  {overlapped seek}
;
;  Convert logical LBA into physical CHS and perform seek.
;  This fuction allows the drive to begin a seek operation (if
;  one is needed) before getting tied up with the SOS driver.
;
; Inputs: BlockNumber: 3 BYTES {R12:14}
;
; Outputs: Block Status: BYTE {3Eh}
;
;********************************************************************

OverLap		and 3Eh, #0FFh-S_Block-B_Block
		ld R2, #CnvrtLogical /256
		ld R3, #CnvrtLogical #256
		call Bank_Call
		jr Z, Ld_BlkStat	; LBA not in spare table
		tm R0, #Spare		; check if block is a spare
		jr Z, Ld_Blk_BB
		or 3Eh, #S_Block	; set Spare Block status
		jr Ld_BlkStat
Ld_Blk_BB	or 3Eh, #B_Block	; otherwise it must be a Bad Block
;
Ld_BlkStat	ld R0, R12 
		ld R1, R13
		xor R0, Cylinder
		xor R1, Cylinder+1
		or R0, R1
		jr NZ, Ld_Blk_Seek	; seek needed
		ld Sector, R15
		cp R14, Head
		jr Z, Ld_Blk_Done	; no head change needed
		call Ld_Blk_Hs		;  else do head change
		jr Ld_Blk_Done
;
Ld_Blk_Seek	ld R2, #Seek /256
		ld R3, #Seek #256
		call Bank_Call
Ld_Blk_Done	jp Bank_Ret
;
Ld_Blk_Hs	ld Head, R14
		and P0, #0FFh-Hs0-Hs1
		tm Head, #001h
		jr Z, Ld_Blk_Hs1
		or P0, #Hs0
Ld_Blk_Hs1	tm Head, #002h
		jr Z, Ld_Blk_Hs2
		or P0, #Hs1
Ld_Blk_Hs2	ret    



L1c77		call L1d20
		call L1d28
		or P2, #008h
L1c80		and >50h, #010h
		clr >51h
		call L1d80
		tm >50h, #040h
		jr NZ, L1ca6
		tm >51h, #010h
		jr Z, L1c98
		call L1d12
		call L1ead
L1c98		tm >50h, #010h
		jr Z, L1c80
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		ld R2, #Strt_FreeProcess /256
		ld R3, #Strt_FreeProcess #256
		call Bank_Call
L1ca6		srp #Wrk_Sys
	assume RP:Wrk_Sys
		ld R2, #Start_Command /256
		ld R3, #Start_Command #256
		call Bank_Call
L1caf		add SPL, #2
		call L1ead
		tm 50h, #020h
		jr Z, L1c80
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		ld R2, #L1FD1 /256
		ld R3, #L1FD1 #256
		call Bank_Call
L1cc3		add SPL, #2
		call L1ead
		tm 50h, #020h
		jr Z, L1c80
		clr 51h
L1cd0		call L1d80
		tm 51h, #004h
		jr NZ, L1c80
		tm 50h, #040h
		jr NZ, L1ceb
		tm 51h, #010h
		jr Z, L1cd0
		call L1d12
		call L1ead
		jp L1c80
L1ceb		srp #Wrk_Sys
	assume RP:Wrk_Sys
		ld R2, #L1fd1 /256
		ld R3, #L1fd1 #256
		call Bank_Call
L1cf4		call L1ead
		jp L1c80

L1cfa		add SPL, #2
		tm 50h, #080h
		jp NZ, L1c77
		tm 50h, #040h
		jp Z, L1c77
		nop   
		nop   
		nop   
		call L1ead
		jp L1c80

L1d12		srp #Wrk_Sys
	assume RP:Wrk_Sys
		ld 53h, #1
		ld R6, #010h
		ld R7, #013h
		ld R0, #07Fh
		lde @RR6, R0
		ret    

L1d20		ld 50h, #010h
		clr 51h
		srp #050h
	assume RP:050h
		ret    

L1d28		and P2, #0FFh-010h
		or P2, #010h
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		or P2, #002h
		ld R0, #01Fh
		ld R1, #070h
		lde R2, @RR0
		ld R1, #072h
		lde R2, @RR0
		ld R1, #074h
		lde R2, @RR0
		ld R1, #076h
		lde R2, @RR0
		ld R1, #07Ah
		lde R2, @RR0
		ld R1, #079h
		lde R2, @RR0
		ld R1, #078h
		lde R2, @RR0
		ld R1, #07Dh
		lde R2, @RR0
		clr R4
		clr R5
L1d59		ld R1, #07Fh
		ld R2, #01Fh
		lde @RR0, R2
		ld R1, #07Eh
		lde R2, @RR0
		and R2, #01Fh
		cp R2, #01Fh
		jr Z, L1d72
		decw RR4
		jr NZ, L1d59
		or 51h, #080h
L1d72		ld R1, #07Ch
		lde R2, @RR0
		ld R1, #079h
		lde R2, @RR0
		and P2, #0FFh-002h
		srp #050h
	assume RP:050h
		ret    

L1d80		srp #Wrk_Sys
	assume RP:Wrk_Sys
		or P2, #002h
		and 50h, #0BFh
		clr R0
		clr R1
		ld R2, #014h
L1d8e		tm P2, #004h
		jr Z, L1da2
		decw  RR0
		jr NZ, L1d8e
		djnz R2, L1d8e
L1d99		or P2, #008h
		and P2, #0FFh-002h
		srp #050h
	assume RP:050h
		ret   
 
L1da2		ld R0, #01Fh
		ld R1, #07Ch
		ld R6, #010h
		ld R7, #01Bh
		ld R2, #080h
		clr R4
		ld R5, #019h
		ld R9, #0AAh
		clr R15
		ld >52h, #07Fh
		ld >53h, #07Fh
		and P2, #0FFh-008h
		lde R8, @RR0
		lde R8, @RR0
L1dc1		lde R8, @RR0
		cp R8, R9
		jr Z, L1dce
		tm P2, #004h
		jr Z, L1dc1
		jr L1d99
L1dce		lde R8, @RR0
		or R8, R8
		jr PL, L1dce
		and >52h, R8
L1dd7		lde R8, @RR0
		or R8, R8
		jr PL, L1dd7
		and >53h, R8
L1de0		lde R8, @RR0
		or R8, R8
		jr PL, L1de0
		nop   
		nop   
		nop   
		nop   
		nop   
		jr L1dfc
L1ded		lde R8, @RR0
		or R8, R8
		jr PL, L1ded
		rlc R15
		ldei @RR6, @R5
		ld R5, #019h
		nop   
		add R4, R15
L1dfc		lde R9, @RR0
		rrc R8
		rlc R9
		add R4, R9
		nop   
		ldei @RR6, @R5
		rrc R8
		lde R10, @RR0
		rlc R10
		add R4, R10
		ldei @RR6, @R5
		nop   
		swap 54h
		rrc R8
		lde R11, @RR0
		rlc R11
		add R4, R11
		ldei @RR6, @R5
		swap 54h
		ld R10,>52h
		rrc R8
		lde R12, @RR0
		rlc R12
		add R4, R12
		ldei @RR6, @R5
		swap 54h
		dec 52h
		rrc R8
		lde R13, @RR0
		rlc R13
		add R4, R13
		ldei @RR6, @R5
		djnz R10, L1e53
		swap 54h
		lde R14, @RR0
		rrc R8
		rlc R14
		add R4, R14
		ldei @RR6, @R5
		ld R3, #2
		tm R2, @R3
		lde R15, @RR0
		or P2, #008h
		jr L1e8f
L1e53		rrc R8
		lde R14, @RR0
		rlc R14
		add R4, R14
		ldei @RR6, @R5
		ld R3, #002h
		rrc R8
		tm R2, @R3
		lde R15, @RR0
		jp Z, L1ded
		or P2, #008h
		rlc R8
		ld R9, #0AAh
L1e6f		tm R2, @R3
		jr Z, L1e7d
		tm P2, #004h
		jr Z, L1e6f
		or >51h, #004h
		jr L1e9f
L1e7d		and P2, #0F7h
		lde R10, @RR0
		lde R10, @RR0
L1e84		lde R10, @RR0
		cp R10, R9
		jr NZ, L1e84
		rrc R8
		jp L1ded
L1e8f		rrc R8
		rlc R15
		add R4, R15
		jr Z, L1e9c
		or >51h, #010h
		jr L1e9f
L1e9c		or >50h, #040h
L1e9f		tm P2, #004h
		jr Z, L1e9f
		or P2, #008h
		and P2, #0FFh-002h
		srp #050h
	assume RP:050h
		ret    

L1ead		srp #Wrk_Sys
	assume RP:Wrk_Sys
		and 50h, #0FFh-020h
		or P2, #002h
		and P2, #0FFh-008h
L1eb8		tm P2, #004h
		jr NZ, L1eb8
		ld R0, #01Fh
		ld R1, #07Dh
		lde R3, @RR0
		ld R1, #07Fh
		ld R6, #010h
		ld R7, #013h
		ld R2, 53h
		ld R3, #002h
		clr R4
		ld R5, #018h
		ldei @R5, @RR6
		ld R9, #0AAh
		lde @RR0, R9
		jr L1edc
L1ed9		or R4, #0
L1edc		add R4, R8
		scf    
		rrc R8
		rrc R15
		lde @RR0, R8
		or R4, #0
		ldei @R5, @RR6
		add R4, R9
		scf    
		rrc R9
		rrc R15
		lde @RR0, R9
		or R4, #0
		ldei @R5, @RR6
		add R4, R10
		scf    
		rrc R10
		rrc R15
		lde @RR0, R10
		or R4, #0
		ldei @R5, @RR6
		add R4, R11
		scf    
		rrc R11
		rrc R15
		lde @RR0, R11
		nop   
		ldei @R5, @RR6
		add R4, R12
		scf    
		rrc R12
		rrc R15
		lde @RR0, R12
		nop   
		ldei @R5, @RR6
		add R4, R13
		scf    
		rrc R13
		rrc R15
		lde @RR0, R13
		dec R2
		jr NZ, L1f4c
		swap R14
		ld R14, R4
		com R4
		inc R4
		scf    
		rrc R4
		rrc R15
		lde @RR0, R4
		rrc R15
		or R15, #080h
		or R4, #0
		or R4, #0
		or R4, #0
		nop   
		lde @RR0, R15
		jr L1fac
L1f4c		ldei @R5, @RR6
		add R4, R14
		scf    
		rrc R14
		rrc R15
		lde @RR0, R14
		ld R5, #018h
		ldei @R5, @RR6
		rrc R15
		or R15, #080h
		nop   
		ld R9, #080h
		lde @RR0, R15
		tm R9, @R3
		jp Z, L1ed9
		or P2, #008h
		or P2, #008h
		or P2, #008h
		clr R10
		lde @RR0, R10
		or P2, #008h
		or P2, #008h
		or P2, #008h
		or P2, #008h
		ld R1, #07Eh
		lde R10, @RR0
		ld R1, #07Ch
		lde R10, @RR0
L1f8b		tm R9, @R3
		jr Z, L1f99
		tm P2, #004h
		jr Z, L1f8b
		or 51h, #004h
		jr L1fc6
L1f99		and P2, #0F7h
		ld R1, #07Dh
		lde R10, @RR0
		ld R1, #07Fh
		nop   
		nop   
		nop   
		ld R10, #0AAh
		lde @RR0, R10
		jp L1edc
L1fac		or P2, #008h
		clr R10
		nop   
		nop   
		nop   
		nop   
		lde @RR0, R10
		ld R1, #07Ch
		lde R10, @RR0
		or 50h, #020h
		clr R2
		nop   
		nop   
		ld R1, #07Eh
		lde R10, @RR0
L1fc6		tm P2, #004h
		jr Z, L1fc6
		and P2, #0FFh-002h
		srp #050h
	assume RP:050h
		ret   
 
L1fd1		call Ext_Pop
		tm 3Eh, #010h
		jp Z, L01e2
		tm 3Eh, #002h
		jr Z, L1ff4
		ld R2, #010h
		ld R3, #01Bh
		lde R0, @RR2
		tm R0, #040h
		jp Z, L01e7
		incw RR2
		lde R0, @RR2
		add R3, #004h
		lde R1, @RR2
L1ff4		pop R2
		pop R2
		ret    

		DB 02000h-$ dup(0FFh)	; pad with $FF's
;====================================================================
;====================================================================

;********************************************************************
; Module Bank1.Assem
;
;********************************************************************
	org 1000h
	phase 2000h		; EPROM will start at 4k so 4k 01000h offset

		DW Checksum1
		DB 1
		DW Passwrd1
		DW Passwrd2
		DB 001h, 031h


;********************************************************************
; Module RdHdr.B1.Assem
;
;  This module contains all but the very most primitive of of
;  procedures (the routines that are resident are listed in the
;  external spec's) that concern themselves with performing a read
;  operation.
;
;	FUNCTION ReadHdr( Parent : BYTE {R8} ) :
;		BOOLEAN
;		Status : BYTE {R0}
;
;********************************************************************

;********************************************************************
;
; Function: ReadHdr
;
;  This function assumes that the heads are positioned over the
;  correct track and reads the block of data following the
;  next sector mark. This routine is used for two reasons: 1) to
;  verify the header that is laid out on a block, and 2) to try
;  to recover the data within a block if the header is munched.
;
; Inputs: Parent: BYTE {R8}
;
; Outputs: ReadHdr: BOOLEAN {zero flag, true if error in ReadHdr}
;          Status:  BYTE {R0}
;
; Global Variables Used: Cylinder, Head, Sector
;
; Local Variables Used: RdHError:  BOOLEAN {R9/bit 7}
;                       RdHExcept: BOOLEAN {R9/bit 6}
;
; Algorithm:
;
;  Begin
;    SetDeadManTimer(ReadBlock, Parent)
;    RdHError:=false
;    RdHExcept:=false
;    RdHSctrGap:=0
;    RdHHdrGap:=0
;   /-
; R | Set-up external RAM address counter for read header
; E | Msel0:1:=Disk<-->Mem
; S | While SectorMark Do Begin End
; I | StartL:=true
; D | While not(SectorDnL) Do Begin End
; E | Status:=StatusPort
; N | StartL:=false
; T | Msel0:1:=Z8<-->Mem
;   \-
;    If Status.State<>NormalEndState
;      Then
;        Reset_StateMachine
;        Abort
;    If Status.ServoErr or not(Status.ServoRdy)
;      Then
;        RdHError:=true
;        RdHExcept:=true
;    If Status.CrcErrL then RdHError:=true
;    ClearDeadManTimer
;    Status/bit7:=RdHError
;    Status/bit7:=RdHExcept
;  End
;
;********************************************************************

ReadHdr		and DiskStat, #0FFh-Wr_Op	; make sure we are reading
		clr RWStat		; clear booleans
		clr 19h
		call L049b
		call L0203
		ld R1, R5		; If Status.State
		and R1, #YMask
		cp R1, #Norm_State
		jr Z, RdHdr_Norm
;
		ld R9, R1
		or R9, #010h
		call Reset_StMach
		or RWStat, #RdHError+RdSMErr
		jr RdH_End
;
RdHdr_Norm	tm R5, #ServoErr	; If ServoErr or not(ServoRdy)
		jr nz, RdHd_ServoErr
		tm R5, #ServoRdy
		jr nz, RdHd_SrvoOk
;
RdHd_ServoErr	or RWStat, #RdHError+RdHSrvoErr	; Then RdHError and RdHServoErr
		jr RdH_End
;
RdHd_SrvoOk	tm R5, #CrcErrL		; If Status.CrcErr
		jr nz, RdH_End
		or RWStat, #RdHError+RdCrcErr
		jr RdH_End
;
RdH_End		tcm RWStat, #RdHError	; set zero flag if error
		jp Bank_Ret



;********************************************************************
; Module Utils.B1
;
; This module contains routines that are part of the main utility
; module and that must be kept in Bank 1.
;
;	PROCEDURE RBuf_To_Buf2
;	PROCEDURE Buf2_To_RBuf
;	PROCEDURE WrBuf_To_Buf2
;	PROCEDURE Buf2_To_WrBuf
;	PROCEDURE RBuf_To_Spr
;	PROCEDURE Spr_To_RBuf
;	PROCEDURE WrBuf_To_Spr
;	PROCEDURE Spr_To_WrBuf
;	PROCEDURE Zero_RdBuf
;	PROCEDURE Zero_Fmt
;	FUNCTION Get_Cyl_H_S( PhysicalBlock : 3 BYTES {RR12} ) :
;		Cylinder : WORD {RR12}
;		Head : BYTE {R14}
;		Sector : BYTE {R15}
;	FUNCTION GoodHdr : BOOLEAN
;		Cylinder : WORD {RR0}
;		Head : BYTE {R2}
;		Sector : BYTE {R3}
;	PROCEDURE BlockMove( Destination : PTR {RR2} 
;		Source : PTR {RR0})
;		FUNCTION UpDate_Hdr : BOOLEAN
;		FUNCTION Get_Type( DriverType : BYTE {R8} ) :
;>                       BlockType : 3 BITS {R8/bits 3:1}
;>                       BlockNumber : 3 BYTES {R12:14}
;>
;********************************************************************

;********************************************************************
;
; Procedures:	Ld_Stand_Stat  {move standard status to output buffer}
;		RBuf_To_Buf2   {move ReadBuffer to Buffer2}
;		Buf2_To_RBuf   {move Buffer2 to ReadBuffer}
;		WrBuf_To_Buf2  {move WriteBuffer to Buffer2}
;		Buf2_To_WrBuf  {move Buffer2 to WriteBuffer}
;		RBuf_To_Spr    {move ReadBuffer to SpareArray}
;		pr_To_RBuf     {move SpareArray to ReadBuffer}
;		Zero_RdBuf     {move zeros to ReadBuffer}
;
; Inputs: none
;
; Outputs: none
;
;********************************************************************

Buf2_To_RBuf	ld R0, #Buf2Array /256
		ld R1, #Buf2Array #256
		ld R2, #RDummy /256
		ld R3, #RDummy #256
		jr B_Move
;
WrBuf_To_Buf2	tm DiskStat, #User_Type	; nop if sparetable data
		jr Z, Return_Vector
		ld R0, #(WBuffer1-1) /256
		ld R1, #(WBuffer1-1) #256
		jr X_To_Buf2
;
Buf2_To_WrBuf	tm DiskStat, #User_Type
		jr Z, Spr_To_WrBuf
		ld R0, #Buf2Array /256
		ld R1, #Buf2Array #256
		ld R2, #(WBuffer1-1) /256
		ld R3, #(WBuffer1-1) #256
		jr B_Move
;
Spr_To_RBuf	ld R0, #SpareArray /256
		ld R1, #SpareArray #256
		ld R2, #RBuffer1 /256
		ld R3, #RBuffer1 #256
		jr B_Move
;
RBuf_To_Spr	ld R0, #RBuffer1 /256
		ld R1, #RBuffer1 #256
X_To_Spr	ld R2, #SpareArray /256
		ld R3, #SpareArray #256
		jr B_Move
;
WrBuf_To_Spr	ld R0, #WBuffer1 /256
		ld R1, #WBuffer1 #256
		jr X_To_Spr
;
RBuf_To_Buf2 	tm DiskStat, #User_Type	; nop if sparetable data
		jr Z, Return_Vector
		ld R0, #RDummy /256
		ld R1, #RDummy #256
X_To_Buf2	ld R2, #Buf2Array /256
		ld R3, #Buf2Array #256
B_Move		call BlockMove
Return_Vector	jp Bank_Ret
;
Spr_To_WrBuf	ld R0, #SpareArray /256
		ld R1, #SpareArray #256
		ld R2, #WBuffer1 /256
		ld R3, #WBuffer1 #256
		jr B_Move


;********************************************************************
;
; Function: UpDate_Cur_Cyl
;
;  This function is responsible for reading the header off of
;  an arbitrary sector. The cylinder information is extracted
;  from the header and placed into the current cylinder memory
;  locations.
;
; Inputs: none
;
; Outputs: UpDate_Cur_Cyl: BOOLEAN {zero flag is set if not(ReadHdr)}
;
; Global Variables Changed: Cur_Cylinder
;
; Algorithm:
;
;  Begin
;    Temp:=GoodHdr(ReadHdr)
;    If Temp
;      Then Cur_Cylinder:=ReadHdr.Cylinder
;    UpDate_Cur_Cyl:=Temp
;  End
;
;********************************************************************

UpDate_Cur_Cyl	call GoodHdr
		jr Z, UD_C_C_End
		ld Cur_Cyl, R0
		ld Cur_Cyl+1, R1
		or R1, #1		; return non-zero status
UD_C_C_End	jp Bank_Ret


;********************************************************************
;
; Function: GoodHdr
;
;  This function is responsible for reading the header off of a
;  sector and checking that header for validity, i.e. whether
;  the cylinder, head, and sector (and their complements) look
;  reasonable.
;
; Inputs: none
;
; Outputs: GoodHdr: BOOLEAN {zero flag is set if header invalid}
;          GoodHdr.Cylinder: WORD {RR0}
;          GoodHdr.Head:     BYTE {R2}
;          GoodHdr.Sector:   BYTE {R3}
;
; Algorithm:
;
;  Begin
;    ReadHdr
;    If inverse(ReadHdr.Cylinder)=ReadHdr.InverseCylinder and
;       inverse(ReadHdr.HdSctr)=ReadHdr.InverseHdSctr
;     Then
;       GoodHdr:=true
;       GoodHdr.Cylinder:=ReadHdr.Cylinder
;       GoodHdr.Head:=ReadHdr.HdSctr/bits 7:6
;       GoodHdr.Sector:=ReadHdr.HdSctr/bits 5:0
;     Else
;       GoodHdr:=false
;  End
;
;********************************************************************

GoodHdr		ld R4, #8		; try hard to find a good header
GdHdr_1		call ReadHdr
		ld R2, #RHHeader /256
		ld R3, #RHHeader #256
		ld R0, #ScrReg0
		ld R1, #6		; load 6 bytes
GdHdr_Lp	ldei @R0, @RR2
		djnz R1, GdHdr_Lp
		srp #Wrk_Scr 		; context switch
	assume RP:Wrk_Scr
		xor R3, R0		; check for valid header
		xor R4, R1
		xor R5, R2
		and R3, R4
		and R3, R5
		com R3
		srp #Wrk_Sys		; context switch
	assume RP:Wrk_Sys
		clr ScrReg6		; assume bad header
		jr Z, GdHdr_2
		tm Excpt_Stat, #Recovery	; check for Recovery on
		jr Z, GdHdr_End
		call ChkOff_NoOff	; set auto-offset if not already on
		ld R2, #10 /256		; wait 100ms before retrying
		ld R3, #10 #256
		call MsWait
		djnz R4, GdHdr_1	; retry if bad header
		jr GdHdr_End
; found a good one
GdHdr_2		ld R0, ScrReg0		; GoodHdr.Cylinder:=ReadHdr.Cylinder
		ld R1, ScrReg1
		ld R2, ScrReg2		; GoodHdr.Head:=ReadHdr.HdSctr/bits 7:6
		swap R2
		rr R2
		rr R2
		and R2, #3		; just leave head info in register
		ld R3, ScrReg2		; GoodHdr.Sectror:=ReadHdr.HdSctr/bits 5:0
		and R3, #3Fh
		ld ScrReg6, #1
;
GdHdr_End	or ScrReg6, ScrReg6	; set zero flag
		jp Bank_Ret


;********************************************************************
;
; Procedure: BlockMove
;
;  This procedure performs the following:
;
;  (Destination) <-- (Source)
;
;  where destination and source are both the same size (namely
;  exactly 524 bytes plus CRC and ECC).
;
; Inputs: Destination: PTR {RR2}
;         Source:      PTR {RR0}
;
; Outputs: none
;
;********************************************************************

BlockMove	call Ext_Push
		ld R4, #(BlockLength+1) /256
		ld R5, #(BlockLength+1) #256
Blk_Move	lde R6, @RR0
		lde @RR2, R6
		incw RR0
		incw RR2
		decw RR4
		jr NZ, Blk_Move
		call Ext_Pop
		ret


;********************************************************************
;
; Function: UpDate_Hdr  {update header}
;
;  This function is responsible for comparing the header information
;  in the buffer (it is assumed that a ReadHdr operation has just
;  been performed and that the header info is currently residing in
;  the ReadHdr buffer space) to that of the global cylinder variable.
;  If the two do not match, then Cur_Cyl is updated to reflect the
;  ReadHdr operation's findings and the function returns a False
;  value indicating that a seek is in order.
;
; Inputs: none
;
; Outputs: UpDate_Hdr: BOOLEAN {zero flag is true if off-track}
;
; Global Variables Used: Cylinder
;
; Global Variables Changed: On_Track, Cur_Cyl
;
; Algorithm:
;
;  Begin
;    DiskStatus.On_Track:=false
;    If GoodHdr
;      Then
;       If RHHeader.Cylinder<>Cylinder
;        Then
;          Cur_Cyl:=RHHeader.Cylinder
;          On_Track:=false
;          UpDate_Hdr:=false
;        Else
;          UpDate_Hdr:=true
;          DiskStatus.On_Track:=true
;  End
;
;********************************************************************

UpDate_Hdr 	call Ext_Push
		and DiskStat, #0FFh-On_Track
		call GoodHdr
		ld R2, #0
		jr Z, UpDate_Err
		ld Cur_Cyl, R0		; Cur_Cyl:=RHHeader.Cylinder
		ld Cur_Cyl+1, R1
		xor R0, Cylinder	; check for correct cylinder address
		xor R1, Cylinder+1
		or R0, R1
		ld R2, #0		; assume failure
		jr NZ, UpDate_Err
		or DiskStat, #On_Track
		ld R2, #1
;
UpDate_Err	or R2, R2
		push FLAGS
		call Ext_Pop
		pop FLAGS
		jp Bank_Ret


L2150		ld R3, #4
		call L215b
		and ScrReg6, #00Fh
		jp Bank_Ret

L215b		ld R1, R13
		ld R2, R14
		ld ScrReg6, R2
L2161		rcf    
		rrc R1
		rrc R2
		djnz R3, L2161
		ret  
  

;********************************************************************
;
; Procedure: Load_SprTbl
;
;  This procedure loads the spare table from disk. The table is
;  found by a linear search of all spare blocks until a block
;  is found where both the Spare Table Identifier field is present
;  and the internal passwords and check byte are valid.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    Seek_Type:=Access_Offset
;    InterLeaveFactor:=Find_InterLeave
;    Found:=false
;    Count:=0
;    i:=NumberOfSpareBlocks
;    While i>0 and Count<2 Do
;      Seek(CnvrtLogical(MulR0_m(i)))
;      j:=0
;      Sector:=0
;      While not(Found) And (j<NbrSctrs) Do
;        If ReadCommon
;          Then
;            If BlockID=SprTblID and
;                 PassWord1=PassWord2=PassWord and
;                 CheckByte is valid
;             Then
;               Found:=true
;               Count:=Count+1
;               If Count>1
;                 Then
;                   If SpareTable.RunNumber<ReadBuffer.RunNumber
;                     Then MoveBlock(SpareTable, ReadBuffer)
;                     Else MoveBlock(SpareTable, ReadBuffer)
;          Else
;            If RdErrCnt<10
;              Then
;                MoveBlock(ReadBuffer, Buffer2)
;                If BlockID=SprTblID and
;                     PassWord1=PassWord2=PassWord and
;                     CheckByte is valid
;                  Then
;                    Found:=true
;                    Count:=Count+1
;                    If Count>1
;                      Then
;                        If SpareTable.RunNumber<ReadBuffer.RunNumber
;                          Then MoveBlock(SpareTable, ReadBuffer)
;                      Else MoveBlock(SpareTable, ReadBuffer)
;        j:=j+1
;        Sector:=(Secotr+InterLeaveFactor) mod NbrSctrs
;      i:=i+1
;    If not(Found)
;      Then Abort
;      Else
;        UpDate_SprTbl
;        Park
;        SlfTst_Result.NoSpareTable:=False
;  End
;
;********************************************************************

Load_SprTbl	call L220c
		ld R6, #76		; i:= NumberOfSpareBlocks
		clr R7			; SprTbl_Found:=false
		or DiskStat, #User_Type
L_SprTbl_Lp	call Ext_Push
		ld R0, R6
		ld R2, #MulR0_m /256
		ld R3, #MulR0_m #256	; do Get_Cyl_H_S after that
		call Bank_Call
		ld R15, #0		; set sector 0
		and DiskStat, #0FFh-Offset_On
		call Seek
		call Ext_Pop
		ld R2, #RdBlk_Vector /256
		ld R3, #RdBlk_Vector #256
		call Bank_Call
		jr NZ, Chk_SprTbl
;
		and R0, #00Fh		; mask unwanted status
		cp R0, #10		; check for any successful reads
		jr GE, L_SprTbl_More
		call Buf2_To_RBuf
		jr Chk_SprTbl

L_SprTbl_More	djnz R6, L_SprTbl_Lp
		or R7, R7		; check if any spare table found
		jr NZ, L_Spr_End
		ld R15, #30		; no spare table found
		jp Abort
;
Chk_SprTbl	ld R0, #RBuffer1 /256
		ld R1, #RBuffer1 #256
		call Chk_PassWord
		jr Z, L_SprTbl_More
;
		ld R2, #(RBuffer1+SpareCheck-SpareArray) /256
		ld R3, #(RBuffer1+SpareCheck-SpareArray) #256
		lde R0, @RR2		; check possible check byte
		incw RR2
		lde R1, @RR2
		srp #Wrk_Scr
	assume RP:Wrk_Scr
		ld R12, #RBuffer1 /256
		ld R13, #RBuffer1 #256
		call SprChk2
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		call Chk_Spr2
		jr Z, L_SprTbl_More
;
		or R7, R7		; check for a SpareTable already found
		jr Z, L_Spr_Move
		srp #Wrk_Scr
	assume RP:Wrk_Scr
		ld R6, #SpareTmStmp /256
		ld R7, #SpareTmStmp #256
		ld R4, #ScrReg0
		call Ld_TmStmp
		ld R6, #(RBuffer1+SpareTmStmp-SpareArray) /256
		ld R7, #(RBuffer1+SpareTmStmp-SpareArray) #256
		ld R4, #ScrRegC
		call Ld_TmStmp
		sub R3, R15
		sbc R2, R14
		sbc R1, R13
		sbc R0, R12
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		jr GE, L_Spr_Inc
		dec R7			; account for old, bogus spare table
L_Spr_Move	call RBuf_To_Spr
L_Spr_Inc	inc R7			; note the arrval of a SpareTable
		cp R7, #2		; see if that's all there is
		jr NZ, L_SprTbl_More
;
L_Spr_End	call UpDate_SprTbl
		and SlfTst_Result, #0FFh-No_SprTbl
		call L220c
		call Park_Heads
		jp Bank_Ret
;
L220c		ld R2, #016h		; clear 24 bytes from RAM 1641h
		ld R3, #041h
		ld R1, #018h
		ld R0, #0
L2214		lde @RR2, R0
		incw RR2
		djnz R1, L2214
		jp Bank_Ret
;********************************************************************
Ld_TmStmp	ld R5, #4		; load 4 bytes
Ld_Tm_Lp	ldei @R4, @RR6
		djnz R5, Ld_Tm_Lp
		ret    


;********************************************************************
;
; Procedure: SprChkSum
;
;  This procedure calculates a 16-bit checksum over the contents
;  of the spare table, and stores the sum within the spare table.
;
; Inputs: none
;
; Outputs: none
;
; Side Effect: ScrReg1, ScrReg2 hold the calculated check byte on return
;
; Algorithm:
;
;  Begin
;    Sum:=0
;    SumPtr:=SpareArray
;    For i:=1 To Length(SpareArray) Do
;      Sum:=Sum+SpareArray[i-1]
;    SpareArray.ChkSum:=Sum
;  End
;
;********************************************************************

SprChkSum	ld R12, #SpareArray /256
		ld R13, #SpareArray #256
SprChk2		ld R14, #(SpareCheck-SpareArray) /256
		ld R15, #(SpareCheck-SpareArray) #256
		clr R4
		clr R5
SprChk_Lp	lde R0, @RR12
		add R5, R0
		adc R4, #0
		incw RR12
		decw RR14
		jr NZ, SprChk_Lp
		lde @RR12, R4		; store high byte of checksum
		incw RR12
		lde @RR12, R5		; store low byte of checksum
		jp Bank_Ret


;********************************************************************
;
; Function: Chk_SprChk
;
;  This function is responsible for verifying that the checksum
;  residing in the spare table is correct.
;
; Inputs: none
;
; Outputs: Chk_SprChk: BOOLEAN {zero flag}
;
; Algorithm:
;
;  Begin
;    TempSum:=SpareTable.CheckSum
;    SpareTable.CheckSum:=SprChkSum
;    If TempSum=SpareTable.CheckSum
;      Then Chk_SprChk:=true
;      Else Chk_SprChk:=false
;  End
;
;********************************************************************

Chk_SprChk	ld R2, #SpareCheck /256
		ld R3, #SpareCheck #256
		lde R0, @RR2
		incw RR2
		lde R1, @RR2
		srp #Wrk_Scr
	assume RP:Wrk_Scr
		call SprChkSum
		srp #Wrk_Sys
	assume RP:Wrk_Sys
Chk_Spr2	xor R0, ScrReg4		; side effect: ScrReg 4:5 hold new checkbyte
		xor R1, ScrReg5
		or R0, R1
		clr R0
		jr NZ, Chk_Spr_End
		ld R0, #1
Chk_Spr_End	or R0, R0		; set zero flag
		jp Bank_Ret


;********************************************************************
;
; Function: Spr
;
;  This function returns the logical block number associated
;  with the parameter passed in. Because there are only two spare
;  blocks containing the spare table, this function accepts
;  only ODD or EVEN input params.
;
; Inputs: SpareTableIndex: BYTE {R8}
;
; Outputs: Spr: 3 BYTES {R12:14}
;
; Algorithm:
;
;  Begin
;    If SpareTableIndex is EVEN
;      Then Spr:=SprBlk0
;      Else Spr:=SprBlk1
;  End
;
;********************************************************************

Spr		tm R8, #1		; If SpareTableIndex is EVEN
		jr NZ, Spr_Odd
;
		ld R12, #HiSpr0
		ld R13, #MidSpr0
		ld R14, #LoSpr0
		jr Spr_End
;
Spr_Odd		ld R12, #HiSpr1
		ld R13, #MidSpr1
		ld R14, #LoSpr1
Spr_End		jp Bank_Ret


;********************************************************************
;
; Procedure: UpDate_SprTbl
;
;  This procedure is responsible for updating the spare table
;  to both of its locations on disk after a change has been made
;  to the table
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    SpareTmStamp:=SpareTmStamp+1
;    SprChkSum
;    ZeroBlock
;    WBuffer1.BlockID:=PassWord
;    For i:=0 To 1 Do
;      MoveBlock(WriteBuffer, SpareTable)
;      TempCyl, TempHead, TempSector:=
;                     Get_Cyl_H_S(CnvrtLogical(SpareTable(Spr(i)))
;      If table not found in SpareTable Then Abort
;      Seek(TemoCyl, TempHead, TempSector)
;      If nor(WriteVerify(Conservative))
;        Then
;          If Recovery And WriteVerify.ErrorCode=Ex_ReadErr
;            Then Exit UpDate_SprTbl
;            Else
;              ZeroBlock
;              WriteBlock
;              MoveBlock(Buffer2, SpareTable)
;              SpareBlock(True, SpareTable, Write_Op, Spr(i))
;  End
;
;********************************************************************

UpDate_SprTbl	ld R12, Cylinder	; save current seek address
		ld R13, Cylinder+1
		ld R14, Head
		ld R15, Sector
		call Ext_Push
;
		ld R2, #FmtOffset /256	; one byte after timestamp
		ld R3, #FmtOffset #256
		ld R15, #4		; get 4 bytes
		ld R1, #1
UpDate_1	decw RR2
		lde R0, @RR2
		add R0, R1		; increment the count
		lde @RR2, R0
		jr C, UpDate_2
		ld R1, #0
UpDate_2	djnz R15, UpDate_1
		call SprChkSum
		ld R4, #2		; write the table to the disk twice
		clr R5			; spare table index
SprB_Lp		call Spr_To_WrBuf
		ld R14, #(WBuffer1+BlockID) /256
		ld R15, #(WBuffer1+BlockID) #256
		call Load_PassWord
		ld R8, R5
		call Spr
		and DiskStat, #0FFh-User_Type
		ld R2, #CnvrtLogical /256
		ld R3, #CnvrtLogical #256
		call Bank_Call
		jr NZ, SprB_Seek
		ld R15, #31
		jp Abort

SprB_Seek	or DiskStat, #Offset_On
		call Seek
		or 3Eh, #S_Block	; say that we've got a spare block
		and DiskStat, #0FFh-User_Type
		ld R2, #WrVer_Common /256
		ld R3, #WrVer_Common #256
		call Bank_Call
		jr NZ, Spr_Next
;
		tm Excpt_Stat, #Recovery	; If Recovery Then ...
		jr NZ, Rcvr_SprTbl
		ld R15, #32
		jp Abort

Rcvr_SprTbl	tm DiskStat, #Wr_Op
		jr NZ, Rcvr_SprT1
		and R9, #00Fh		; check for noisy read
		cp R9, #SprThresh
		jr LE, Spr_Next
Rcvr_SprT1	ld R0, #0A5h
		call L05a3
		or DiskStat, #Wr_Op
		ld R2, #RW_Common /256
		ld R3, #RW_Common #256
		call Bank_Call
		ld R8, R5
		call Spr
		ld R2, #Spr_Enter /256
		ld R3, #Spr_Enter #256
		call Bank_Call
		jr Z, Rcvr_SprTbl
;
Spr_Next	inc R5			; do next table
		djnz R4, SprB_Lp
		call Ext_Pop
		call Seek		; get back to original seek address
		jp Bank_Ret


;********************************************************************
;
; Function: Chk_PassWord
;
;  This function is responsible for checking if the 32 bits
;  pointed to by the input parameter match with the controller's
;  32 bit password
;
; Inputs: PassWordPtr: PTR {SysReg0:1}
;
; Outputs: Chk_PassWord: BOOLEAN {zero flag}
;
; Algorithm:
;
;  Begin
;    If @PassWordPtr=PassWord
;      Then Chk_PassWord:=true
;      Else Chk_PassWord:=false
;  End
;
;********************************************************************

Chk_PassWord	srp #Wrk_Scr
	assume RP:Wrk_Scr
		ld R4, #4		; check 4 bytes
		ld R2,10h
		ld R3,11h
		ld R14, #Password /256
		ld R15, #Password #256
Chk_P_Lp	ldc R0, @RR14		; get a byte of the password
		incw RR14
		lde R1, @RR2		; get a byte of test string
		incw RR2
		cp R0, R1
		clr R0			; assume failure
		jr NZ, Chk_P_End
		djnz R4, Chk_P_Lp
		ld R0, #1
Chk_P_End	or R0, R0		; set flags
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		jp Bank_Ret


;********************************************************************
;
; Procedure: SpareCount
;
;  This procedure is responsible for incrementing/decrementing
;  the Spare/Bad Block count. If the total count exceeds
;  MaxSpares-5 then a status bit is set for this command only.
;
; Inputs: Command: 2 BITS {R0/Bits 1:0}
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    Case Command Of
;      0: Increment the spare count
;      1: Increment the bad block count
;      2: Decrement the bad block count
;      Otherwise Abort
;    If SpareCount+BadBlockCount>=MaxSpares-5
;      Then
;        Excpt_Stat.SprTbl_Warn:=true
;        SetStatus(SprBlk_Warn)
;  End
;
;********************************************************************

SpareCount	ld R1, R0		; get command
		and R1, #0FCh		; check for illegal command
		jr Z, SprCnt_1
		ld R9, R0
		ld R15, #33
		jp Abort
;
SprCnt_1	ld R2, #SprCount /256
		ld R3, #SprCount #256
		lde R1, @RR2		; assume spare count increment
		inc R1
		cp R0, #0		; check for Inc_SpareCount
		jr Z, S_C_Spare
		incw RR2		; get address of BadCount
		lde R1, @RR2		; get bad block count
		cp R0, #1		; check for Inc_BadBlock
		jr Z, S_C_BadInc
		dec R1			; otherwise Decrement bad block count
		jr S_C_BadEnd
;
S_C_BadInc	inc R1
S_C_BadEnd	lde @RR2, R1		; store new count
		jr SprCnt_End
;
S_C_Spare	lde @RR2, R1		; store new count
SprCnt_End	call Chk_SprCnt
		jp Bank_Ret
;
Chk_SprCnt	ld R2, #SprCount /256
		ld R3, #SprCount #256
		lde R0, @RR2		; get spare count
		incw RR2
		lde R1, @RR2		; get bd block count
		add R0, R1
		cp R0, #76-5		; check for spare count overflow
		jr LT, Chk_Spr_Ret
		or Excpt_Stat, #SprTbl_Warn
		call SS_SprWarn
Chk_Spr_Ret	jp Bank_Ret



;********************************************************************
; Module Spare1.Assem (a continuation of Spare)
;
;	FUNCTION SrchSpTabl(LogicalBlock : 3 BYTES {R12:14}
;		ElementType: BYTE {R15}) :
;		PhysicalBlock : 3 BYTES {R12:14}
;		Status : BYTE {R0}
;		ElementPtr : BYTE {R1}
;	FUNCTION GetNewSpare(BlockNumber : 3 BYTES {R12:14}) : BYTE {R0}
;	PROCEDURE AddSpare(BlockType : 3 BITS {R8/bits 3:1}
;		SpareType : BIT {R8/bit 4}
;		Location  : BYTE {R15}
;		LogicalBlock : 3 BYTES {R12:14})
;	PROCEDURE DeleteSpare(Location : BYTE {R15}
;		LogicalBlock : 3 BYTES {R12:14})
;
;********************************************************************

;********************************************************************
;
; Function: GetNewSpare
;
;  This function accepts either a physical block number or
;  a logical block number and returns a one byte index into
;  the Spare Table's bit map describing the location of the
;  block that can be used as a spare
;
; Inputs: BlockNumber: 3 BYTES {R12:14}
;
; Outputs: GetNewSpare BYTE {R0}
;
; Global Variables Used: SpareBitMap
;
; Local Variables: Bit:   ScrReg0
;                  Temp1: ScrReg1
;                  Temp2: ScrReg2
;                  NoHis: ScrReg3/bit 7
;                  NoLos: ScrReg3/bit 6
;
; Algorithm:
;
;  Begin
;    Bit:=CnvrtLogical div k {get physical blocknumber divided by
;                           the number of blocks between spares }
;    If SpareBitMap[Bit]=0
;      Then GetNewSpare:=Bit
;      Else
;        NoHis:=false
;        NoLos:=false
;        Temp1:=Bit
;        While not(NoHis) and SpareBitMap[Temp1]=1 Do
;          Temp1:=Temp1+1
;          If Temp1>=76 Then NoHis:=True
;        Temp2:=Bit
;        While not(NoLos) and SpareBitMap[Temp2]=1 Do
;          Temp2:=Temp2-1
;          If Temp2<0 Then NoLos:=true
;        If NoHis and NoLos
;          Then Abort {spare table full}
;          Else
;            If NoHis
;              Then GetNewSpare:=Temp2
;              Else
;                If Temp1-Bit > Bit-Temp2
;                  Then GetNewSpare:=Temp2
;                  Else GetNewSpare:=Temp1
;  End
;
;********************************************************************

GetNewSpare	call Ext_Push		; save state
; do a range check first. Rene's capacity is 38064 (9834h) blocks
;  plus 76 spares, which gives a total of 610*2*32 = 39040 (9880h). 
		ld R4, R13		; LBA mid byte
		cp R4, #098h		; do range check
		jr NZ, Gns_RC1
		ld R4, #097h
Gns_RC1		rcf    
		rrc R4
		cp R4, #04Ch
		jr LT, Gns_RCok
		ld R15, #53
		jp Abort
;
Gns_RCok	ld R13, R4
		ld R12, #TestBitMap
		ld R2, #TSC_BitMap /256
		ld R3, #TSC_BitMap #256
		call Bank_Call		; If BitMap[Bit]=0 ...
		ld R0, R4		; assume Bit is unused
		jr Z, Gns_End		; jump if Then
;
		ld R5, R4		; Else ...
		clr R7
Gns_Lp1		ld R13, R5		; test for bit map location = 0
		ld R12, #TestBitMap
		ld R2, #TSC_BitMap /256
		ld R3, #TSC_BitMap #256
		call Bank_Call
		jr Z, Gns_Lp1End
		inc R5			; bump Temp1
		cp R5, #76
		jr LT, Gns_Lp1
		or R7, #080h		; NoHis:=true
Gns_Lp1End	ld R6, R4
Gns_Lp2		ld R13, R6		; test for bit map location = 0
		ld R12, #TestBitMap
		ld R2, #TSC_BitMap /256
		ld R3, #TSC_BitMap #256
		call Bank_Call
		jr Z, Gns_Lp2End
		dec R6
		jr GT, Gns_Lp2
		or R7, #040h		; NoLos:=true
Gns_Lp2End	tcm R7, #0C0h		; If NoHis and NoLos...
		jr NZ, Gns_Chk_Hi
;
		ld R0, #1		; status byte 1
		ld R1, #SprBlk_Hard	; spare table full
		call L029b		; SetStatus ???
		ld R15, #13
		jp Abort
;
Gns_Chk_Hi	ld R0, R6		; assume NoHis
		tm R7, #080h		; test for NoHis
		jr NZ, Gns_End
;
		ld R0, R5		; assume NoLos
		tm R7, #040h		; test for NoLos
		jr NZ, Gns_End
;
		ld R1, R5
		sub R1, R4		; otherwise find which is closer
		sub R4, R6
		ld R0, R6		; assume Temp2 is closer
		cp R1, R4
		jr NC, Gns_End
		ld R0, R5		; otherwise Temp1 is closer
Gns_End		ld 36h, R0
		call Ext_Pop
		ld R0, 36h
		jp Bank_Ret


;********************************************************************
;
; Procedure: AddSpare {add an element to the spare table}
;
;  This procedure is responsible for adding an element to the spare
;  table. It accepts a 1 byte value describing the location within
;  the spare table (it is assumed that the caller has already used
;  GetNewSpare) as well as the LogicalBlockNumber and whether the
;  block being added to the table is a Spare block or a Bad Block.
;
; Inputs: BlockType:          3 BITS {R8/bits 3:1}
;         SpareType:          BOOLEAN {R8/bit4}
;         Location:           BYTE {R15}
;         LogicalBlockNumber: 3 BYTES {R12:14}
;
; Outputs: none
;
; Global Variables Used: SpareCount
;
; Algorithm:
;
;  Begin
;    HeadPtr:=Get_HeadPtr(LogicalBlockNumber)
;    If HeadPtr.Nil
;      Then
;        HeadPtr.Nil:=False
;        HeadPtr.Ptr:=Location
;        SegPtrArray[LogicalBlockNumber/bits 10:16]:= HeadPtr
;      Else
;        Ptr:=HeadPtr.Ptr
;        Ptr:=Get_EoList(Ptr)
;        Ptr^.Nil:=False
;        Ptr^.Ptr:=Location
;    Ptr:=Get_Ptr(Location)
;    Ptr^.Nil:=True
;    Ptr^.Used:=True
;    Ptr^.Useable:=True
;    Ptr^.Spare:=Spare
;    Ptr^.Type:=SpareType
;    Ptr^.Token:=LogicalBlockNumber/bits 0:9
;    TCS_BitMap(Set, Location) {set the bit map location for the add}
;    If SpareType=Spare
;      Then SpareCount:=SpareCount+1
;      Else BadCount:=BadCount+1
;  End
;
;********************************************************************

AddSpare	ld R2, #Get_HeadPtr /256
		ld R3, #Get_HeadPtr #256
		call Bank_Call		; If HeadPtr.Nil ...
		jr NZ, ADS_Else1
;
		and R0, #0FFh-Nil	; Then HeadPtr.Nil:=false
		or R0, R15		;      HeadPtr.Ptr:=Location
		lde @RR2, R0		; create link
		jr ADS_UpDate
;
ADS_Else1	ld R2, #Get_EoList /256
		ld R3, #Get_EoList #256
		call Bank_Call		; search till end of list
		and R1, #0FFh-Nil	; Ptr^.Nil:=false
		lde @RR2, R1
		add R3, #3		; get Ptr^.Ptr
		adc R2, #0
		lde @RR2, R15		; create link
ADS_UpDate	ld R0, R15		; get structure ptr
		ld R2, #Get_Ptr /256
		ld R3, #Get_Ptr #256
		call Bank_Call		; create a read ptr out of it
		ld R0, #Nil+Used+Useable
		or R0, R8		; merge Spare/Bad Block/Type info
		tm DiskStat, #User_Type
		jr Z, ADS_UpDt1
		or R0, #002h
		jr ADS_UpDt2
ADS_UpDt1	or R0, #008h
ADS_UpDt2	lde @RR2, R0
		incw RR2		; point to element.HiToken
		ld R0, R13		; get HiToken
		and R0, #3
		lde @RR2, R0
		incw RR2		; piont to element.LoToken
		lde @RR2, R14		; store LoToken
		ld R12, #SetBitMap
		ld R13, R15
		ld R2, #TSC_BitMap /256
		ld R3, #TSC_BitMap #256
		call Bank_Call		; update the bit map
		jp Bank_Ret


;********************************************************************
;
; Procedure: DeleteSpare {delete an element from the spare table}
;
;  This procedure is responsible for deleting an element from the spare
;  table. It accepts a 1 byte value describing the location within
;  the spare table (it is assumed that the caller has already used
;  GetNewSpare) as well as the LogicalBlockNumber.
;
; Inputs: Location:           BYTE {R15}
;         LogicalBlockNumber: 3 BYTES {R12:14}
;
; Outputs: none
;
; Local Variables: Ptr1^.Status: BYTE {ScrReg5}
;
; Global Variables Used: SpareCount
;
; Algorithm:
;
;  Begin
;    Location:=CnvrtLogical(Load_Logical)
;    If not(CnvrtLogical.Found) Then Abort
;    If Get_Head(LogicalBlockNumber).Ptr = Location
;      Then Head.Nil:=true
;      Else
;        Ptr1:=Get_Ptr(Location)
;        If Ptr1^.Nil=true
;          Then Ptr(PreviousElement)^.Nil:=true
;          Else Ptr(PreviousElement)^.Ptr:=Ptr1^.Ptr
;    zero out the deleted element
;    TCS_BitMap(Clear, Location) {free up the bit map location}
;  End
;
;********************************************************************

DeleteSpare	call Load_Logical
		ld R2, #CnvrtLogical /256
		ld R3, #CnvrtLogical #256
		call Bank_Call
		ld R15, R1
		jr NZ, Chk_HdPtr
		ld R15, #14
		jp Abort
;
Chk_HdPtr	call Load_Logical
		ld R2, #Get_HeadPtr /256
		ld R3, #Get_HeadPtr #256
		call Bank_Call		; If Get_HeadPtr ...
		ld ScrReg4, R0
		ld R0, R15
		ld R2, #Get_Ptr /256
		ld R3, #Get_Ptr #256
		call Bank_Call
		lde R0, @RR2
		tm R0, #Nil
		jr Z, Chk_Chain
		cp ScrReg4, R15
		jr NZ, Chk_Chain	; Else ...
;
		ld R2, #Get_HeadPtr /256
		ld R3, #Get_HeadPtr #256
		call Bank_Call
		ld R0, #Nil		; Then Head.Nil:=true
		lde @RR2, R0
		jr Zero_Element
;
Chk_Chain	ld ScrReg5, R0
		or R0, #Nil
		lde @RR2, R0		; break the chain
		ld R0, ScrReg4
		ld R2, #Get_EoList /256
		ld R3, #Get_EoList #256
		call Bank_Call		; get Ptr(Previous) in ScrReg0,1
		ld R0, ScrReg5		; get the original status back
		tm R0, #Nil		; If Ptr1^.Nil
		ld R2, ScrReg6		; get Ptr(Previous)
		ld R3, ScrReg7
		jr Z, D_Chk_Else	; Else ...
;
		lde R0, @RR2
		or R0, #080h
		lde @RR2, R0
		jr Zero_Element
;
D_Chk_Else	cp R15, ScrReg4
		jr NZ, Get_Previous
		ld R2, #Get_HeadPtr /256
		ld R3, #Get_HeadPtr #256
		call Bank_Call
		jr Save_Previous
;
Get_Previous	add R3, #3		; get to Ptr(Previous)^.Ptr
		adc R2, #0
Save_Previous	push R2
		push R3
		ld R0, R15
		ld R2, #Get_Ptr /256
		ld R3, #Get_Ptr #256
		call Bank_Call
		add R3, #3		; get to Ptr1^.Ptr
		adc R2, #0
		lde R0, @RR2
		pop R3
		pop R2
		lde @RR2, R0		; Ptr(Previous)^.Ptr:=Ptr1^.Ptr
Zero_Element	ld R0, R15		; get Ptr1 once more
		ld R2, #Get_Ptr /256
		ld R3, #Get_Ptr #256
		call Bank_Call
		ld R0, #0FFh		; initial element
		ld R1, #4		; zero 4 bytes
Zero_E_Lp	lde @RR2, R0
		incw RR2
		djnz R1, Zero_E_Lp
		ld R12, #ClearBitMap
		ld R13, R15
		ld R2, #TSC_BitMap /256
		ld R3, #TSC_BitMap #256
		call Bank_Call
		jp Bank_Ret


ReSeek		or DiskStat, #Offset_On
		and DiskStat, #0FFh-Offset_Set
		call L04db
		decw  RR0
		call L04d0
		ld R12,Cylinder
		ld R13,Cylinder+1
		ld R14,Head
		ld R15,Sector


;********************************************************************
;
; Procedure: Seek
;
;  This procedure accepts cylinder, head, and sector values
;  and then calls PositionHeads.
;
; Inputs:  Cylinder: WORD {R12}
;          Head:     BYTE {R14}
;          Sector:   BYTE {R15}
;
; Outputs: none
;
; Global Variables Changed: Cylinder, Head, Sector
;
; Algorithm:
;
;  Begin
;    LastSeekAddress:=CurrentSeekAddress
;    DiskStat.Parked:=false
;    If DiskStat.SeekComplete
;      Then
;        i:=4
;        While i>0 and not(PositionHeads(Wait, Dmt_Seek, Cylinder,
;                                       Head, Sector) Do
;          If not(Recovery) Then Abort
;          i:=i-1
;        If i=0 Then Abort
;      Else wait up to 1 sec for ServoReady, if timeout Abort
;    DiskStat.SeekComplete:=true
;    DiskStat.OnTrack:=true
;    GlobalCylinder:=Cylinder
;    SelectHead( Head )
;    GlobalSector:=Sector
;    SectorCount:=SectorCount+1
;    Chk_Offset
;  End
;
;********************************************************************

Seek		call Ext_Push
		ld R2, #LastSeek_Stat /256	; save last seek address
		ld R3, #LastSeek_Stat #256
		ld R0, #Cylinder	
		ld R1, #4
Seek_LSk	ldei @RR2, @R0		; copy Cylinder, Head, Sector 
		djnz R1, Seek_Lsk	; to RAM 124Fh
		ld R4, #4		; four attempts
;
; **** PosHeads inline
Seek_Lp		ld R0, #1		; do all servoing off of head 1
		call SelectHead
		call ServoOk		; test if Servo is in a reasonable state
		jr Z, PosHds_6		; leave if servo can't be made useable
; *** CalcMagDir inline
		ld R10, Cur_Cyl		; get current cylinder
		ld R11, Cur_Cyl+1
		sub R11, R13		; subtract target cylinder
		sbc R10, R12
		jr LT, C_MagDir_Else	; negative --> go backwards
		ld R0, #Hd_Dir_Rev	; set direction negative
		jr S_Glbl_Cyl
;
C_MagDir_Else	com R11			; 2's complement sutraction result
		com R10
		add R11, #1
		adc R10, #0
		ld R0, #Hd_Dir_Frwd	; set direction positive
;
S_Glbl_Cyl	ld R1, R10		; check for no seek condition
		or R1, R11
		jr Z, PosHds_5		; distance is zero!
		or R10, R0		; merge in direction
; *** CalcMagDir inline
		and DiskStat, #0FFh-On_Track-Parked-SeekComplete-Offset_Set
		tm DiskStat, #Offset_On
		jr NZ, GtSk_LdAO
		tm Excpt_Stat, #Recovery
		ld R2, #0		; default is no offsets
		jr Z, GtSk_LdNo
;
		call Get_Zone
		ld R2, #0		; default is no offsets
		jr LT, GtSk_LdNo
;
		ld R2, R0		; set amount of offset
		jr GS_LdAO1
;
GtSk_LdAO	ld R2, #Off_Auto	; select access with auto offset for Nisha
GS_LdAO1	ld R0, #Access_Offset
		tm 3Eh, #HDA_Type	; do we have a Nisha HDA?
		jr Z, GS_LdNo1		;  yes -->
		ld R2, #0		; else select simple access for Rodime
;
GtSk_LdNo	ld R0, #Access
GS_LdNo1	or R0, R10		; plus direction & MSB magnitude
		ld R1, R11		; LSB magnitude
		ld R3, #0
		call ServoCmnd1
		call L047c
		tm DiskStat, #Offset_On	; check for auto_offset
		jr Z, PosHds_4
;
		or DiskStat, #Offset_Set
PosHds_4	ld R10, #25000 /256	; intermediate timer of 1sec
		ld R11, #25000 #256
PosHds_42	decw RR10
		jr Z, PosHds_5
		call L028e
		push R0
		call L047c
		ld R0, #128
PosHds_41	djnz R0, PosHds_41
		pop R0
		tm R0, #ServoRdy	; THEN loop until timeout OR ServoRdy
		jr Z, PosHds_42
;
		or DiskStat, #SeekComplete
PosHds_5	ld Cur_Cyl, R12
		ld Cur_Cyl+1, R13
;
PosHds_6	call Chk_SStat
; **** PosHeads inline
		jr NZ, Seek_End
		and DiskStat, #0FFh-Offset_Set	; remove any offsets
		tm Excpt_Stat, #Recovery
		jr Z, Seek_Abt
		ld R2, #20 /256
		ld R3, #20 #256
		call MsWait		; wait 200 ms before retrying
		or R4, R4		; counter expired?
		jp Z, Seek_Abt
		dec R4
		jp NZ, Seek_Lp		; go for a next try
		call Seek_Reset		; do a reset before the last one
		jp Seek_Lp
;
Seek_Abt	call SetStatus
		or DiskStat, #SeekComplete
		ld R15, #34
		jp Abort
;
Seek_End	or DiskStat, #On_Track+SeekComplete
		ld Cylinder, R12
		ld Cylinder+1, R13
		ld R0, R14
		call SelectHead
		ld Sector, R15
		tm 3Eh, #HDA_Type	; Nisha HDA?
		jr NZ, Seek_End1	;  no -->
		ld R4, #020h
		ld R5, #007h
		lde R0, @RR4		; get value from RAM 2007 ???
		incw RR4
		lde R1, @RR4		; 2008 ???
		sub R13, R1
		sbc R12, R0
		jp LT, L263a
Seek_End1	and P0, #0FFh-RWI	; RWI on
		jp L263d
L263a		or P0, #RWI		; RWI off
L263d		call L04db
		incw RR0		; seek count ???
		call L04d0
		call Chk_Offset
		call L028e
		call Ext_Pop
		jp Bank_Ret
;
Chk_SStat	call L028e		; LoadStatus ???
		call L0265
		ld R1, R0		; get copies of both ServoErr and ServoRdy
		com R0			; ServoErr := NOT( ServoErr )
		rl R0			; get ServoErr in same position as ServoRdy
		and R0, R1		; return AND( ServoRdy, NOT( ServoErr ) )
		and R0, #ServoRdy	; set zero flag
		ret    
;
Seek_Reset	call ResetServo
		ld R0, #DataRecal
		call Restore
		ret    


;********************************************************************
;
; Procedure: SelectHead
;
;  This procedure is responsible for selecting the correct head
;  on the disk.
;
; Inputs: Head: BYTE {R0}
;
; Outputs: none
;
;********************************************************************

SelectHead	ld Head, R0
		and P0, #0FFh-Hs0-Hs1	; select Head 0
		tm Head, #001h
		jr Z, Sel_Head1
		or P0, #Hs0	
Sel_Head1	tm Head, #002h
		jr Z, SelHd_Ret
		or P0, #Hs1
SelHd_Ret	ret    


;********************************************************************
;
; Function: ServoOk
;
;  This function is responsible for determining if the servo is in a
;  reasonable state to perform commands. In other words if ServoReady
;  and NOT(ServoError) then the servo is healthy, wealthy and wise.
;  If, on the other hand, ServoError is active then the state of
;  ServoReady determines the type of action to perform to try to get
;  the servo back to a nice state:
;
;  ServoError and ServoReady: Read Status
;  ServorError and Not(ServoReady): do Data Recal
;
; Inputs: none
;
; Outputs:	ServOk: BOOLEAN {Zero Flag, True if NOT(ServoOk) }
;		RecalcMagDir: BYTE {R0}
;
; Local Variables:	Retry   : BYTE {R15}
;			SioRetry: BYTE {R8}
;			Done    : BOOLEAN { }
;			ControllerStatusPTR : PTR {RR12}
;
; Algorithm:
;
; BEGIN
;   IF Recovery 
;     THEN
;       IF ServoError
;         THEN
;           IF Write_Operation THEN WrBuf_To_Buf2
;           Restore( DataRecal )
;           Buf2_To_WrBuf
;         ELSE
;           IF NOT( ServoReady )
;             THEN
;               IF Write_Operation THEN WrBuf_To_Buf2
;               S_Reset
;               Buf2_To_WrBuf
;   ServoOk := NOT( ServoError )
; END
;
;********************************************************************

ServoOk		tm Excpt_Stat, #Recovery	; IF Recovery
		jr Z, S_Ok_End
;
		call L028e
		call L0265
		tm R0, #ServoErr	; IF ServoError
		jr Z, SOk_ChkRdy
;
		tm R0, #020h
		jr Z, L26a7
		call Chk_MvWrData
		ld R0, #0
		ld R1, #0
		ld R2, #0
		ld R3, #1
		call ServoStatus1
		jr L26bc
L26a7		call Chk_MvWrData
		ld R0, #DataRecal
		call Restore
		jr L26bc
SOk_ChkRdy	tm R0, #ServoRdy	; IF NOT( ServoErr )
		jr NZ, S_Ok_End		; AND ServoRdy
;
SOk_Park	call Chk_MvWrData	; save write data if Write_Op
		call Seek_Reset
L26bc		call L26d1
S_Ok_End	call Chk_SStat
		jp Bank_Ret
;
;********************
;
Chk_MvWrData	call SetStatus
		tm DiskStat, #Wr_Op	; check for write_op
		jr Z, MvWr_End
		call WrBuf_To_Buf2
MvWr_End	ret    
;
;********************
;
L26d1		call UpDate_Hdr
		jr NZ, L26db
		ld R0, #DataRecal
		call Restore
L26db		call Buf2_To_WrBuf
		ret    


;********************************************************************
;
; Procedure: Auto_Offset
;
;  This procedure is used to set auto_offset to the servo processor.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
; BEGIN
;   Temp := Head
;   SelectHead( 1 )
;   ServoCmnd( Offset, 0, Off_Auto, S_Rate_57_6 )
;   @Get_Zone := ServoStatus( 1 ).Offset_Value
;   DiskStat.Offset_Set := True
; END
;
;********************************************************************

Auto_Offset	call Ext_Push
		push Head		; save the current head value
		ld R0, #1		; select head 1 for offsetting
		call SelectHead
		tm 3Eh, #HDA_Type	; do we have aRodime mechanism?
		jr NZ, Auto_Off_Ret	;  yes --> exit
;
		ld R0, #Access_Offset
		ld R1, #0
		ld R2, #Off_Auto
		ld R3, #0
		call ServoCmnd1
		ld R0, #ReadStatus
		ld R1, #0
		ld R2, #0
		ld R3, #1		; read servo stat 1 to find offset value
		call ServoStatus1
		ld R2, #(SStatus0+1) /256	; get offset amount
		ld R3, #(SStatus0+1) #256
		lde R0, @RR2
		xor R0, #01Fh		; get correct polarity
		and R0, #03Fh		; mask off unwanted stuff
		push R0
;
		ld R12,Cylinder
		ld R13,Cylinder+1
		call Get_Zone
		pop R0
		lde @RR2, R0		; store new value
;
Auto_Off_Ret	pop R0			; re-select original head
		call SelectHead
		call Ext_Pop
		or DiskStat, #Offset_Set
		jp Bank_Ret
;
;******************
;
Chk_Offset	tm DiskStat, #Offset_On
		jr Z, Chk_Off_Ret
ChkOff_NoOff	tm DiskStat, #Offset_Set	; THEN check for offset already on
		jr NZ, Chk_Off_Ret
		call Auto_Offset
Chk_Off_Ret	ret    


;********************************************************************
;
; Function: Get_Zone
;
;  This function is responsible for identifying the zone that the
;  heads are currently positioned in; a zone being a section of the
;  drive that is assumed to have a homogeneous servo offset
;  characteristic.
;
; Inputs: Cylinder: WORD {RR12}
;
; Outputs:	Get_Zone : BYTE {R0},
;		Get_Zone1 : BOOLEAN {zero flag is set if servo err}
;
; Algorithm:
;
; BEGIN
;   Get_Zone := Zone_Table[ Cylinder/NbrZones ]
;   IF ( Get_Zone <= MinOffset )
;     THEN Get_Zone1 := False
;     ELSE GEt_Zone1 := True
; END
;
;********************************************************************

Get_Zone	ld R0, R12		; use seek address for zone calc
		ld R1, R13
		ld R2, #ZoneShift
		rcf    
GtZn_Lp		rrc R0			; rotate down the cylinder value
		rrc R1
		djnz R2, GtZn_Lp
		ld R2, #Zone_Table /256
		ld R3, #Zone_Table #256
		add R3, R1		; add offset to table
		adc R2, #0
		lde R0, @RR2		; get offset value
		tm R0, #Dir_Frwd	; mask all but sign bit
		ld R1, #Off_Dir_Rev
		jr NZ, GtZn_Push
		ld R1, #Off_Dir_Frwd
GtZn_Push	and R0, #01Fh
		cp R0, #MinOffset	; check for lower bound on offset
		push FLAGS
		or R0, R1		; merge sign and magnitude
		pop FLAGS
		jp Bank_Ret



;********************************************************************
; Module Srvo2.B1.Assem
;
; This module holds those routines that make up most of the
; auxiliary servo commands.
;
;	PROCEDURE ServoCmnd( CommandString : 4 BYTES {R0:3} )
;	PROCEDURE ServoStatus( CommandString : 4 BYTES {R0:3}
;			BufferPtr : PTR {RR14} )
;	FUNCTION ServoStore : BOOLEAN
;	FUNCTION ServoLoad( BufferPtr : PTR {RR2} ) : BOOLEAN
;	FUNCTION Restore( RecalType : BYTE {R0} ) : BOOLEAN
;	PROCEDURE SrvoRcvry
;	PROCEDURE Load_SrvoCmnd
;	PROCEDURE Park_Heads
;	PROCEDURE ResetServo
;
;********************************************************************

;********************************************************************
;
; Procedure: SrvoCmnd  {send the servo a command}
;
; Inputs:  CommandString: 4 BYTES {R0:3}
;
; Outputs: none
;
; Global Variables Changed: SrvoCmndBuffer
;
; Local Variables: SioRetry: BYTE {R8}
;
; Algorithm:
;
;  Begin
;    SrvoCmndBuffer[CommandByte]:=R0
;    SrvoCmndBuffer[LoDiffByte]:=R1
;    SrvoCmndBuffer[OffsetByte]:=R2
;    SrvoCmndBuffer[StatusByte]:=R3
;    SioRetry:=4
;    While not(ServoStore(CommandString) And SioRetry>0 Do
;      SioRetry:=SioRetry-1
;    If SioRetry=0 Abort
;  End
;
;********************************************************************

ServoCmnd	ld R0, R12
		ld R1, R13
		ld R2, R14
		ld R3, R15
ServoCmnd1	call Ext_Push
		call Load_SrvoCmnd
		ld R4, #10		; SioRetry:=10
;
Srv_C_Lp	call ServoStore
		jr nz, Srv_C_End
		tm Excpt_Stat, #Recovery
		jr Z, Srv_C_Abort
		djnz R4, Srv_C_Lp
		call ResetServo
		call Ext_Pop
		call Ext_Push
		call Load_SrvoCmnd
		call ServoStore
		jr nz, Srv_C_End
;
Srv_C_Abort	ld R15, #35
		jp Abort
;
Srv_C_End	call Ext_Pop
		jp Bank_Ret


;********************************************************************
;
; Procedure: ServoStatus  {read a status location from the servo}
;
; Inputs:  CommandString: 4 BYTES {R0:3}
;          BufferPtr:     PTR {RR14}
;
; Outputs: none
;
; Global Variables Changed: SrvoCmndBuffer
;                           @BufferPtr
;
; Local Variables: SioRetry: BYTE {R8}
;
; Algorithm:
;
;  Begin
;    ServoCmnd
;    If not(ServoLoad(BufferPtr)) Then Abort
;  End
;
;********************************************************************

ServoStatus	ld R3, R0
		ld R0, #0
		ld R1, #0
		ld R2, #0
ServoStatus1	call Ext_Push
		ld R4, #4		; retry 4 times
Servo_StLp1	call ServoCmnd1
		call ServoLoad
		jr Z, Srv_St_End
		tm Excpt_Stat, #Recovery
		jr Z, Servo_St_Abort
		call Ext_Pop
		call Ext_Push
		djnz R4, Servo_StLp1
;
Servo_St_Abort	ld R15, #36
		jp Abort
;
Srv_St_End	call Ext_Pop
		jp Bank_Ret


;********************************************************************
;
; Function: Restore
;
;  This function performs a Recal operation on the servo.
;  Normally, a ReadHeader operation is to be performed after
;  the Servo comes ready, and the current cylinder is to be
;  subsequently updated. This mechanism (doing the ReadHeader)
;  can be turned off by clearing the RdHdrRecal bit in the
;  exception working register set.
;
; Inputs:  RecalType: BYTE {R0}
;
; Outputs: Restore: BOOLEAN {zero flag, true if not(ServoRdy)}
;
; Algorithm:
;
;  Begin
;    ServoCmnd(RecalType, 0, 0, 57.6kBaud)
;    While not(ServoRdy) And 2 seconds hasn't gone by Do Begin End
;    If DiskStat.RdHdrRecal and ServoRdy
;      Then If not(UpDate_Cur_Cyl) Then Abort
;      Else
;        If RecalType=DataRecal
;          Then CurCyl:=Init_Cyl
;          Else CurCyl:=Max_Cyl
;    Restore:=ServoRdy
;  End
;
;********************************************************************

Restore		call Ext_Push
		clr R1
		clr R2
		clr R3
		call ServoCmnd1
		and DiskStat, #0FFh-On_Track-Offset_Set
		ld R6, R0
		ld Cur_Cyl, #HiMaxCyl	; assume FrmtRecal
		ld Cur_Cyl+1, #LoMaxCyl
		cp R6, #FrmtRecal
		jr Z, Rest_Up2
;
		ld Cur_Cyl, #Init_HiCyl_B	; DataRecal track for Nisha
		ld Cur_Cyl+1, #Init_LoCyl_B
		tm 3Eh, #HDA_Type	; do we have aNisha mechanism?
		jr Z, Rest_Up2		;  yes -->
		ld Cur_Cyl, #Init_HiCyl_A	; else DataRecal track for Rodime
		ld Cur_Cyl+1, #Init_LoCyl_A
Rest_Up2	clr R5
		ld R4, #0D5h		; max time to wait is two seconds
;
Restore_Lp	call L028e		; ??? LoadStatus ???
		tm R0, #ServoRdy
		jr NZ, Rest_UpDate
		decw RR4
		jr NZ, Restore_Lp
		clr R0			; pass error status to exit
		jr Restore_End
;
Rest_UpDate	tm DiskStat, #RdHdrRecal
		jr Z, Rest_Up1
		cp R6, #FrmtRecal	; don't try to read headers here!
		jr Z, Rest_Up1
		call UpDate_Cur_Cyl
		jr NZ, Rest_Up1		; leave if positioned correctly
;
		call SS_NoHdr
		ld R15, #025h
		call Abort
;
Rest_Up1	ld R0, #1
Restore_End	push R0			; save result
		call Ext_Pop
		and DiskStat, #0FFh-Offset_Set-Parked-On_Track
		or DiskStat, #SeekComplete
		pop R0
		or R0, R0		; set zero flag
		jp Bank_Ret


;********************************************************************
;
; Procedure: SrvoRcvry  {servo recovery}
;
;  This procedure's responsibility is to do everything within reason
;  to make certain that the Servo Processor is Healthy, Wealthy, and
;  Wise; and if it can't then there is no point in using the Servo.
;
; Inputs:  none
;
; Outputs: none
;
; Local Variables: i:     BYTE {R8}
;                  Error: BOOLEAN {R9}
;
; Global Variabled Changed: On_Track, Cur_Cyl
;
; Global Variables Used: Cylinder, Head, Sector
;
; Algorithm:
;
;  Begin
;    ZeroHeader
;    Error:=false
;    If ServoError
;      Then Error:=not(ServoOk)
;      Else
;       Error:=not(ReadHdr)
;       If not(Error)
;        Then
;         If ReadHdr.Cylinder<>Cylinder
;          Then
;           Cur_Cyl:=ReadHdr.Cylinder
;           On_Track:=false
;    If not(On_Track) Then Seek(Cylinder, Head, Sector)
;  End
;
;********************************************************************

SrvoRcvry	call Ext_Push		; save caller's stuff
		call ZeroHeader
		call Chk_SStat
		jr NZ, Srvo_R_Sok
		call ServoOk
;
Srvo_R_Sok	call UpDate_Hdr		; If ReadHdr.Cylinder<>Cylinder
		jr NZ, Srvo_R_Leave
		ld R0, #1		; status byte 1
		ld R1, #Stat_Seek
		call L029b		; ??? SetStatus ???
		call ReSeek
Srvo_R_Leave	call Ext_Pop
		jp Bank_Ret


;********************************************************************
;
; Procedure: Park_Heads
;
;  This procedure moves the heads in a closed-loop fashion
;  (access command vs Park command) to a location away from the
;  user data area. The attempt here is to provide some additional
;  protection from power failures, and the such, from accidentally
;  writing bogus data on the disk.
;
; Inputs: none
;
; Outputs: none
;
; Algorithm:
;
;  Begin
;    Seek(HiParkCylinder, LowParkCylinder, 0, 0)
;    Set_SeekNeeded
;  End
;
;********************************************************************

Park_Heads	and DiskStat, #0FFh-Offset_On
		ld R12, #ParkCyl_B /256	; park track for Nisha
		ld R13, #ParkCyl_B #256
		tm 3Eh, #HDA_Type	; Nisha HDA?
		jr Z, Park_Hds1		;  yes -->
		ld R12, #ParkCyl_A /256	;  else select track for Rodime
		ld R13, #ParkCyl_A #256
Park_Hds1	clr R14
		clr R15
		call Seek
		or DiskStat, #Parked
		and DiskStat, #0FFh-On_Track
		jp Bank_Ret


;********************************************************************
;
; Function: ServoStore
;
;  The function of this routine is to transmit a command string
;  to the Servo Processor. The command string is expected to
;  reside in the global variable SrvoCmndBuffer (thus providing a
;  record of the last command sent to the servo). ServoStore then
;  attempts to complete the transmission to the Servo, and returns
;  a boolean variable indicating whether the transmission was
;  completed or not.
;
; Inputs:  Parent: BYTE {R1}
;
; Outputs: ServoStore: BOOLEAN {zero flag, true if transmission failed}
;
; Local Variables: Retry: BYTE {R6}
;                  i:     BYTE {R4}
;                  j:     BYTE {R5}
;
; Algorithm:
;
;  Begin
;    SrvoCmndBuffer[CheckByte]:=GenerateCheckByte(PTR(SrvoCmndBuffer),
;                                                 Length(SrvoCmndBuffer))
;    Retry:=10
;    Repeat
;      For i:=1 To 5 Do
;        While IRQ.Serial_Output=false Or not(SioReady) Do
;          Begin End
;        Sio.Data:=SrvoCmndBuffer[i]
;      Retry:=Retry-1
;      For j:=1 To (value for 250s wait) Do Begin End
;    Until not(SioReady) Or Retry=0
;    For j:=1 To (value for 400s wait) Do Begin End
;      If Retry=0
;        Then ServoStore:=false
;        Else ServoStore:=true
;  End
;
;********************************************************************

ServoStore	call Ext_Push		; save context
		ld R14, #SrvoCmndBuf /256
		ld R15, #SrvoCmndBuf #256
		ld R8, #S_Cmnd_Len-1
		call Gen_Chk_Byte
		ld R14, #SrvoCmndBuf /256
		ld R15, #SrvoCmndBuf #256
		ld R6, #8500 /256
		ld R7, #8500 #256
		ld R4, #S_Cmnd_Len
		call L02ab
;
Srvo_St_1	tm P2, #SioRdy		; While not(SioReady)
		jr NZ, Srvo_St_3
		decw RR6
		jr NZ, Srvo_St_1
		jr Srvo_St_Exit

Srvo_St_3	and IRQ, #0FFh-Serial_Out-Serial_In	; clear old interrupts
		lde R0, @RR14		; get a command byte
		ld SIO, R0		; send it to servo
		incw RR14		; point to next command byte
;
Srvo_St_2	tm IRQ, #Serial_Out	; While IRQ.Serial_Out=false
		jr Z, Srvo_St_2
;
		djnz R4, Srvo_St_1	; loop till all command bytes are sent
		and IRQ, #0FFh-Serial_Out	; clear old interrupts
		ld R5, #88
Srvo_Wt_1	djnz R5, Srvo_Wt_1	; do a 250s wait
		ld R6, #001h
		tm P2, #SioRdy		; if not(SioReady) then Servo
		jr Z, Srvo_St_Exit	;  took the bytes and is munchin' on 'em
		ld R6, #0
Srvo_St_Exit	call L02c9
		or R6, R6		; test for Retry=0
		push FLAGS
		call Ext_Pop		; return to original context
		pop FLAGS
		jp Bank_Ret


;********************************************************************
;
; Function: ServoLoad
;
;  This function is responsible for reading a status back
;  from the servo. The bytes that it receives are stored into a
;  buffer that is passed into the routine in the form of a PTR.
;  ServoLoad passes back to the caller a boolean variable describing
;  whether the checkbyte was valid (i.e. the transmission was a
;  success).
;
; Inputs:  Parent:    BYTE {R1}
;          BufferPtr: PTR {R2:3}
;
; Outputs: ServoLoad: BOOLEAN {zero flag, true if transmission failed}
;
; Global Variables Changed: Buffer pointed to by RR2
;
; Local Variables: i:          BYTE {R4}
;                  TempBufPtr: PTR {RR10}
;
; Algorithm:
;
;  Begin
;    For i:=1 To 5 Do
;      While not(IRQ.Serial_Input) Do Begin End
;      Buffer[i]:=Sio.Data
;    ServoLoad:=Check_Check_Byte(Ptr(Buffer),5)
;  End
;
;********************************************************************

ServoLoad	call Ext_Push
		ld R14, #SStatus0 /256
		ld R15, #SStatus0 #256
		ld R6, #8500 /256
		ld R7, #8500 #256
		ld R4, #5		; load i
		call L02ab
Srvo_Ld_Wt	tm IRQ, #Serial_In
		jr NZ, Srvo_Ld_Wt1
		decw RR6
		jr NZ, Srvo_Ld_Wt
		or R0, #1
		jr L2902
Srvo_Ld_Wt1	and IRQ, #0FFh-Serial_In	; clear old interrupts
		ld R0, SIO		; read SIO
		lde @RR14, R0		; and store in buffer
		incw RR14		; point to next location in buffer
		djnz R4, Srvo_Ld_Wt	; loop till all bytes are read
		ld R14, #SStatus0 /256	; get original buffer ptr
		ld R15, #SStatus0 #256
		ld R8, #4		; length of buffer
		call Chk_Chk_Byte
L2902		push FLAGS
		call L02c9
		call Ext_Pop
		pop FLAGS
		jp Bank_Ret


;********************************************************************
;
; Procedure: Load_SrvoCmnd  {load servo command buffer}
;
;  This procedure loads the global array ServoCmndBuffer
;  with the information contained within R0:3
;
; Inputs: SrvoCmndBuffer[0]: BYTE {R0}
;         SrvoCmndBuffer[1]: BYTE {R1}
;         SrvoCmndBuffer[2]: BYTE {R2}
;         SrvoCmndBuffer[3]: BYTE {R3}
;
; Outputs: none
;
;********************************************************************

Load_SrvoCmnd	srp #Wrk_Scr
	assume RP:Wrk_Scr
		ld R2, #SrvoCmndBuf /256
		ld R3, #SrvoCmndBuf #256
		ld R1, #4		; load 4 bytes
		ld R0, #010h		; start with what's in SysReg0
Ld_S_Cmnd_Lp	ldei @RR2, @R0
		djnz R1, Ld_S_Cmnd_Lp
		srp #Wrk_Sys
	assume RP:Wrk_Sys
		jp Bank_Ret


;********************************************************************
;
; Procedure: ResetServo
;
;  This procedure is responsible for performing all the
;  necessary tasks in resetting the servo. This includes
;  positioning the heads over the data field and keeping
;  the world straight about it (cylinder is set to
;  MaxDataCylinder because a DataRecal positions the heads
;  at the closest data cylinder to the inside)
;
; Inputs: none
;
; Outputs: none
;
; Global Variables Changed: Cylinder
;
; Algorithm:
;
;  Begin
;    ServoRst:=true
;    wait for 50ms to make certain that Reset is valid
;    ServoRst:=false
;    wait for 1 sec to allow motor and servo to get ready
;    If not(ServoRdy) or ServoError Then Abort
;    If not(ServoStore(ReadStatus, x, x, 0)
;      Then Abort
;    If not(ServoLoad(NormalReadStatusBuffer)
;      Then Abort
;    If not(Restore(DataRecal)) Then Abort
;    DiskStatus.On_Track:=false
;  End
;
;********************************************************************

ResetServo	call Ext_Push
		and TMR, #0FFh-T0_CntEn	; halt T0
		ld PRE0, #5		; PRE0:=1, continuous run
		ld T0, #1		; Nisha runs at 58.59kbps (7,5MHz/128)
		or TMR, #T0_CntEn+T0_Load
		ld R11, #4		; 4 retries
;
S_Rst_1		and P2, #0FFh-Not_ServoRst
		ld R2, #0
		ld R3, #080h
S_Rst_2		decw RR2
		jr NZ, S_Rst_2
		or P2, #Not_ServoRst
		ld R2, #300 /256
		ld R3, #300 #256
		call MsWait		; busy wait for 3s
		ld R0, #ReadStatus	; try talking to the Servo
		clr R1			;  (00 00 00 02)
		clr R2
		ld R3, #2
		call Load_SrvoCmnd
		call ServoStore
		jr NZ, S_Rst_Ld
		djnz R11, S_Rst_1
		ld R10, #S_Store
;
S_Rst_Abort	ld R15, #39
		jp Abort
;
S_Rst_Ld	call ServoLoad
		ld R10, #S_Load
		jr Z, S_Rst_Ld1
		djnz R11, S_Rst_1
		jr S_Rst_Abort
; determine HDA type:
; Rene works with two different drive mechanisms: Apple's Nisha and Rodime's RO552
; The current type is indentified from the Servo status response.
S_Rst_Ld1	ld R14, #SStatus0 /256
		ld R15, #SStatus0 #256
		lde R0, @RR14
		cp R0, #1		; check HDA type
		jr NZ, S_Rst_Ld2	;  01h --> Rodime
;
		and 3Eh, #0FFh-HDA_Type	; set HDA_Type = Nisha
		ld R0, #FrmtRecal	; and recalibrate
		call Restore
		jr S_Rst_Ret
;
S_Rst_Ld2	or 3Eh, #HDA_Type	; set HDA_Type = Rodime RO552
S_Rst_Ret	call Ext_Pop
		jp Bank_Ret



;********************************************************************
; Module SlfTst.B1.Assem   {Selftest}
;
;	FUNCTION: MtrSpd
;	FUNCTION: TrackCount
;	FUNCTION: SctrCount
;	FUNCTION: RwTest
;
;********************************************************************


;********************************************************************
;
; Function: Selftest
;
;  This function performs some check to confirm Nisha's integrity.
;
;  Inputs: none
;
;  Outputs: SlfTst_Result: BYTE
;
;********************************************************************

SelfTest	or Excpt_Stat, #Recovery	; try our best to pass this test
		ld 5Dh, #0
		call MtrSpd
		jr Z, ST_Mtr_Gd
;
		ld R2, #1500 /256
		ld R3, #1500 #256	; wait another 21 ms
		call MsWait
		call MtrSpd
		jr NZ, Slf_Leave
;
ST_Mtr_Gd	and SlfTst_Result, #0FFh-Disk_Speed
Slf_Tracks	call TrackCount
		and SlfTst_Result, #0FFh-Servo_Fail
Slf_Sectors	call SctrCount
		and SlfTst_Result, #0FFh-Sector_Cnt
Slf_State	call LoadStatus		; check state machine state
		and SlfTst_Result, #0FFh-State_Fail
Slf_RwTest	call RwTest		; see if we can read and write
		jr Z, Slf_Leave
		and SlfTst_Result, #0FFh-Rw_Fail
;
Slf_Leave	jp Bank_Ret


;********************************************************************
;
; Function: MtrSpd  {motor speed}
;
;  This function is responsible for measuring the motor
;  speed. This is done by timing the interval between
;  consecutive index marks
;
; Inputs: none
;
; Outputs: MtrSpd: BOOLEAN {zero flag, NOT set if failure}
;
;********************************************************************

MtrSpd		and IRQ, #0FFh-IRQ_Index	; clear old event
		ld R0, #1		; assume failure
		ld R4, #1600 /256	; load dead man timer
		ld R5, #1600 #256	;  (22,3ms)
		ld R2, #11000 /256	; timeout after about 4 rotations
		ld R3, #11000 #256	;  (153,6ms)
MtrSpd_Lp1	tm IRQ, #Irq_Index	; wait for index to come around
		jr NZ, MtrSpd_Idx	;  got him
		decw RR2		; decrement timeout
		jr NZ, MtrSpd_Lp1
		jr MtrSpd_Lv
;
MtrSpd_Idx	and IRQ, #0FFh-IRQ_Index-Irq_Sector	; clear events
		clr R0			; clear counter
		clr R1
MtrSpd_Lp2	tm IRQ, #Irq_Index	; wait for one rev
		jr NZ, MtrSpd_End	;  done
		incw RR0		; 0.0140 ms/lp or 71.6 cnts/ms
		decw RR4		; decrement timeout
		jr NZ, MtrSpd_Lp2
;
MtrSpd_End	ld R14, R1
		ld R13, R0
		ld R12, #0
		call L2150		; get speed within tolerance in R2 
		ld R0, #1		; assume failure
		cp R2, #05Bh		; accept speeds between 20 and 24 ms
		jr LT, MtrSpd_Lv
		cp R2, #064h
		jr GT, MtrSpd_Lv
		ld R0, #0		; otherwise pass
;
MtrSpd_Lv	or R0, R0		; set flags
		ret    


;********************************************************************
;
; Function: TrackCount
;
;  This function is responsible for counting the number of
;  tracks that are available on the servo.
;
; Inputs: none
;
; Outputs: TrackCount: BOOLEAN {zero flag, NOT set if failure
;
; Algorithm:
;
;  Begin
;   Restore(FrmtRecal)
;   Seek(Cyl=0)
;  End
;
;********************************************************************

TrackCount	call ResetServo		; try to get the servo in a nice state
		and DiskStat, #0FFh-RdHdrRecal	; don't read any headers!
		ld R0, #DataRecal
		call Restore
		ld R12, #0		; cylinder = 0
		ld R13, #069h
		ld R14, #0		; head = 0
		ld R15, #0		; sector = 0
		call Seek
		ret    


;********************************************************************
;
; Function: SctrCount
;
;  This function counts the number of sector marks between
;  successive index marks and returns a true value if
;  the number of sectors counted equals NbrSctrs.
;
; Inputs: none
;
; Outputs: SctrCount: BOOLEAN {zero flag, NOT set if failure}
;
;********************************************************************

SctrCount	di     
		tm 3Eh, #HDA_Type	; Nisha mechanism?
		jr Z, S_Cnt_Exit	;  yes --> leave
		ld R4, #4		; try four times
;
S_Cnt_Retry	clr R2			; count:=0
		ld R6, #0		; set timeout counter
		ld R7, #0
		and IRQ, #0FFh-Irq_Index	; clear old index marks
S_Cnt_1		tm IRQ, #Irq_Index	; wait for index mark
		jr NZ, S_Cnt_2
		decw RR6
		jr NZ, S_Cnt_1
		jr S_Cnt_Abort		; abort with timeout
S_Cnt_2		and IRQ, #0FAh
S_Cnt_3		tm P3, #IndexMark	; While not(Index)
		jr NZ, S_Cnt_End
		decw RR6
		jr Z, S_Cnt_Abort
		tm IRQ, #Irq_Sector
		jr Z, S_Cnt_3
		inc R2			; bump the sector count
		and IRQ, #0FFh-Irq_Sector
		jr S_Cnt_3
S_Cnt_End	cp R2, #NbrSctrs
		jr Z, S_Cnt_Exit	; passed, return
		djnz R4, S_Cnt_Retry
;
		ld R15, #59		; sector count mismatch
		jp Abort
S_Cnt_Exit	jp Bank_Ret
;
S_Cnt_Abort	ld R15, #60		; sector count index mark timeout
		jp Abort


;********************************************************************
;
; Function: RwTest
;
;  This test moves the heads over a track away from the data
;  area (useable data area) and performs a write verify
;  on block zero of that track. If a failure occurs, the test
;  will continue on the next sequential sector on that track
;  until all sectors have been written to. If there are no
;  successful transfers on any of the sectors of this track then
;  the test is assumed to have failed.
;
; Inputs: none
;
; Outputs: RwTest: BOOLEAN {zero flag, NOT set if failure
;
; Algorithm:
;
;  Begin
;    Seek(RwTest track)
;    Repeat
;      If not(WrVerCommon) And RdErrCnt=10
;        Then
;          Sector:=Sector+1
;          If Sector>NbrSctrs
;            Then Done:=true
;       Else Done:=true
;    Until Done
;    If Sector>NbrSctrs
;      Then RwTest:=false
;      Else RwTest:=true
;  End
;
;********************************************************************

RwTest		or DiskStat, #RdHdrRecal
		ld R0, #DataRecal
		call Restore
		ld R5, #0
		jr Z, RwTest_End
;
RwTest1		ld R12, #Tst_HiCyl_B	; assume values for Nishas
		ld R13, #Tst_LoCyl_B
		ld R14, #Tst_Head_B
		tm 3Eh, #HDA_Type	; Nisha HDA?
		jr Z, RwTest2		;  yes -->
		ld R12, #Tst_HiCyl_A	; else use values for Rodime
		ld R13, #Tst_LoCyl_A
		ld R14, #Tst_Head_A
RwTest2		ld R15, #Tst_Sctr
		call Seek
		ld R5, #NbrSctrs
;
RwTest_Lp	call ZeroHeader
		ld R0, #039h
		call L05a3
		push R5
		or DiskStat, #Wr_Op
		ld R2, #WrBlk_Vector /256
		ld R3, #WrBlk_Vector #256
		call Bank_Call
		pop R5
		jr Z, Rw_Next
;
		ld R0, #0		; assume a failure
		call L05a3
		push R5
		and DiskStat, #0FFh-Wr_Op
		ld R2, #RdBlk_Vector /256
		ld R3, #RdBlk_Vector #256
		call Bank_Call
		pop R5
		jr NZ, RwTest_End
;
Rw_Next		inc Sector
		djnz R5, RwTest_Lp
RwTest_End	or R5, R5		; set zero flag
		jr Z, RwTest_Exit	;  set --> passed!
		ld R1, #039h
		ld R2, #BlockLength /256
		ld R3, #BlockLength #256
		ld R4, #RBuffer1 /256	; RAM 1019h
		ld R5, #RBuffer1 #256
L2ac6		lde R0, @RR4
		cp R0, R1
		jr NZ, RwTest_Abort
		incw RR4
		decw  RR2
		jr NZ, L2ac6
		call Park_Heads
RwTest_Exit	ret    
;
RwTest_Abort	ld R15, #49		; RW test failed
		jp Abort


L2adb		or SlfTst_Result,SlfTst_Result
		jp NZ, L2b57
		ld R4, #001h
L2ae3		ld R2, #012h
		ld R3, #055h
		ld R1, #3
		ld R0, #Wrk_Sys+12
L2aeb		ldei @R0, @RR2
		djnz R1, L2aeb
		add R14, #001h
		adc R13, #0
		ld R12, #0
		ld R0, #0
		ld R1, #098h
		ld R2, #034h
		call L0459
		jr NC, L2b08
		ld R12, #0
		ld R13, #0
		ld R14, #0
L2b08		ld R2, #012h
		ld R3, #055h
		ld R1, #3
		ld R0, #Wrk_Sys+12
L2b10		ldei @RR2, @R0
		djnz R1, L2b10
		ld R2, #014h
		ld R3, #07Fh
		ld R1, #3
		ld R0, #Wrk_Sys+12
L2b1c		ldei @RR2, @R0
		djnz R1, L2b1c
		call Ext_Push
		and DiskStat, #0FFh-Wr_Op-Offset_On
		or DiskStat, #User_Type
		ld R2, #OverLap /256
		ld R3, #OverLap #256
		call Bank_Call
		and DiskStat, #0FFh-Wr_Op-Offset_On
		ld R2, #RW_Common /256
		ld R3, #RW_Common #256
		call Bank_Call
		jr Z, L2b48
		tm 3Eh, #B_Block
		jr Z, L2b4f
		ld R2, #Pro_Rd_BB /256
		ld R3, #Pro_Rd_BB #256
		call Bank_Call
L2b48		ld R2, #Data_Ex_Handler /256
		ld R3, #Data_Ex_Handler #256
		call Bank_Call
L2b4f		call Ext_Pop
		djnz R4, L2ae3
		call Park_Heads
L2b57		call L05ba
		jp Bank_Ret



Strt_FreeProcess	di     
		srp #Wrk_Sys		; get into a reasonable state
	assume RP:Wrk_Sys
		clr SPH
		ld SPL, #Stack_Top
		tm 3Eh, #004h
		jp Z, Chk_Pk_Jp
		call L04db
		tm R0, #0F8h		; do arm sweep every 2k seeks or so
		jr Z, Chk_Park
;
		clr R0			; 10h SeekCount
		clr R1			; 11h SeekCount+1
		call L04d0
		ld R12, #0		; seek to data recal location
		ld R13, #0
		ld R14, #0
		ld R15, #0
		call Seek
		ld R12, #0
		ld R13, #040h
		ld R14, #0
		ld R15, #0
		call Seek
		and DiskStat, #0FFh-On_Track
Chk_Park	tm DiskStat, #Parked
		jr NZ, FreeP_NoPark
		call L2adb
		jp Chk_Pk_Jp
;
FreeP_NoPark	call L04ed
		inc R0
		call L04e6
		tm R0, #00Fh
		jp NZ, Chk_Pk_Jp
		ld R2, #SlfTst_Table /256
		ld R3, #SlfTst_Table #256
		swap R0
		rl R0
		add R3, R0
		adc R2, #0
		ldc R14, @RR2
		incw RR2
		ldc R15, @RR2
		jp @RR14
;
SlfTst_Table	DW Free_Ram 
		DW Free_Eprom
		DW Free_MtrSpd
		DW Free_SctrCnt  
		DW Free_RW  
;
Chk_Pk_Jp	call L028e
		jp L01f8
;
Free_Ram	call Chk_SprChk		; verify spare table checksum
		jr NZ, Chk_Pk_Jp
;
		or SlfTst_Result, #Ram_Fail
		jr Chk_Pk_Jp
;
Free_Eprom	ld R0, #Eprom2
		call EpromTest
		jr Z, Chk_Pk_Jp
;
		or SlfTst_Result, #Eprom_Fail
		jr Chk_Pk_Jp
;
Free_SctrCnt	call SctrCount
		jr Chk_Pk_Jp
;
Free_MtrSpd	call MtrSpd
		jr Z, Chk_Pk_Jp
;
		or SlfTst_Result, #Disk_Speed
		jr Chk_Pk_Jp
;
Free_RW		or SlfTst_Result, #Rw_Fail	; assume failure
		call RwTest1
		jr Z, Chk_Pk_Jp
;
		and SlfTst_Result, #0FFh-Rw_Fail
		jp L01f0



;********************************************************************
; Module ECC.B1.Assem   {Error Check and Correction}
;
; This module contains all the relevant files pertaining
; to the ECC method and algorithm used on Widget/Nisha
;
;	FUNCTION Ecc : BOOLEAN
;	PROCEDURE ShiftAndXor( VAR R1, R2, R3, R4, R5, R6 : BYTE {R1:6} )
;	PROCEDURE TestMod8( J : WORD {RR8} )
;	PROCEDURE Test0( J : WORD {RR8} )
;
;********************************************************************

;********************************************************************
;
; Function: Ecc
;
;  This function is responsible for 1) checking if the data in the
;  ReadBuffer is correctable and 2) correcting that data if it is
;  correctable.
;
;  The method used was prepared by:
;    Neil Glover
;    Daza Systems Technology Corp.
;    1801 Aspen St.
;    Broomfield, Co. 80020
;    (303) 466-5228
;
; Inputs:  none
;
; Outputs: Ecc: BOOLEAN {zero flag is set if not correctable}
;
; K1 = BitLength(DataField)+BitLength(CrcField)+BitLength(EccField)-41
;    = (1+532)*8 + 2*8 + 6*8 -41
;    = 4287
;
; Correction Span = 12 bits
;
;  R2Mask = $00
;  R3Mask = $0F
;
; Syndrome Bytes begin at ReadArray.RBuf1Ecc
;
; Local Variables: R1:          BYTE {R1}
;                  R2:          BYTE {R2}
;                  R3:          BYTE {R3}
;                  R4:          BYTE {R4}
;                  R5:          BYTE {R5}
;                  R6:          BYTE {R6}
;                  Correctable: BOOLEAN {R7/bit 7}
;                  Aligned:     BOOLEAN {R7/bit 6}
;                  Done:        BOOLEAN {R7/bit 5}
;                  J:           WORD {RR8}
;
; Algorithm:
;
;  Begin
;    R1:=SynfromeByte[1] {most significant byte}
;    R2:=SynfromeByte[2]
;    R3:=SynfromeByte[3]
;    R4:=SynfromeByte[4]
;    R5:=SynfromeByte[5]
;    R6:=SynfromeByte[6]
;    If (R1=R2=R3=R4=R5=R6=0)
;      Then Ecc:=false
;      Else
;        J:=K1
;        Aligned:=false
;        Done:=false
;        Correctable:=false
;        While R1=0 Do
;          ShiftRegsLeft 1 Byte {left-hand justify syndrome}
;          J:=J+8
;        While not(Done) Or not(Aligned) Do
;          ShiftAndXor
;          If R1=0
;            Then
;              If R4=R5=R6=0 And R2*R2Mask=0 And R3*R3Mask
;                Then
;                  Aligned:=true
;                  TestMod8
;            If not(Aligned) Then Test0
;            If not(Done) Then J:=J-1
;        While not(Done) Do
;          ShiftAndXor
;          If R=0
;            Then TestMod8
;            Else Test0
;          If not(Done) Then J:=J-1
;        If Correctable
;          Then
;            J:=J div 8
;            Buffer1[J]:=Buffer1[J] Xor R2
;            Buffer1[J+1]:=Buffer1[J+1] Xor R3
;            Buffer1[J+2]:=Buffer1[J+2] Xor R4
;            BlockMove(Buffer2, RBuffer
;        Ecc:=Correctable
;  End
;
;********************************************************************

K1		EQU 4271
R2Mask		EQU 0
R3Mask		EQU 00Fh
Ecc_Correctable	EQU 080h
Ecc_Aligned	EQU 040h
Ecc_Done	EQU 020h

ECC		clr R7			; clear booleans
		ld R8, #K1 /256
		ld R9, #K1 #256
		ld R0, #0		; get ready to check for all zero syndrome
		ld R11, #6		; load six bytes, R1..R6:=Syndrome Bytes
		ld R12, #RBuf1Ecc /256
		ld R13, #RBuf1Ecc #256
		ld R10, #Wrk_Sys+1	; load syndrome bytes into registers
;
Ecc_Ld_Lp	ldei @R10, @RR12
		or R0, @R10
		djnz R11, Ecc_Ld_Lp
		jp Z, Ecc_End
;
Ecc_LHJ_While	or R1, R1		; While R1=0 Do
		jr NZ, Ecc_Align
		ld R1, R2		; shift left 1 byte
		ld R2, R3
		ld R3, R4
		ld R4, R5
		ld R5, R6
		clr R6
		add R9, #8		; J:=J+8
		adc R8, #0
		jr Ecc_LHJ_While
;
Ecc_Align	call ShiftAndXor
		jr NZ, Ecc_Al_1
		ld R0, R4		; If (R4=R5=R6=0)
		or R0, R5
		or R0, R6
		ld R15, R3		; And (R3*R3Mask=0)
		and R15, #R3Mask
		or R0, R15
		jr NZ, Ecc_Al_1
;
		or R7, #Ecc_Aligned
		call TestMod8
;
Ecc_Al_1	tm R7, #Ecc_Aligned
		jr NZ, Ecc_Al_2
;
		call Test0
;
Ecc_Al_2	tm R7, #20h
		jr NZ, Ecc_Crct
;
		decw RR8		; J:=J-1
		tm R7, #Ecc_Done+Ecc_Aligned
		jr Z, Ecc_Align
;
Ecc_Shift	call ShiftAndXor
		jr NZ, Ecc_Shft_Else
		call TestMod8
		jr Ecc_Shft_2
;
Ecc_Shft_Else	call Test0
Ecc_Shft_2	tm R7, #Ecc_Done
		jr NZ, Ecc_Crct
		decw RR8		; J:=J-1
		jr Ecc_Shift
;
Ecc_Crct	tm R7, #Ecc_Correctable
		jr Z, Ecc_End
;
		ld R10, #3		; J:=J div 8
Ecc_Div8	rrc R8
		rrc R9
		djnz R10, Ecc_Div8
		and R8, #1Fh		; mask off unwanted carries
		ld R12, #RDummy /256
		ld R13, #RDummy #256
		add R13, R9
		adc R12, R8
		ld R11, #Wrk_Sys+2	; start with R2
		ld R10, #3		; correct 3 bytes
;
Ecc_Crct_Lp	lde R1, @RR12
		xor R1, @R11
		ld @R11, R1
		ldei @RR12, @R11
		djnz R10, Ecc_Crct_Lp
;
		ld R2, #RBuf_To_Buf2 /256
		ld R3, #RBuf_To_Buf2 #256
		call Bank_Call
		tm R7, #Ecc_Correctable	; set correctable flag
;
Ecc_End		jp Bank_Ret


;********************************************************************
;
; Procedure: ShiftAndXor
;
;  This procedure is used to shift the current syndrome bytes
;  (assumed to be located in R1:6) to the right 1 bit and then
;  Xor the syndromes with the reciprocal polynominal if needed.
;
; Inputs: R1: BYTE {R1}
;         R2: BYTE {R2}
;         R3: BYTE {R3}
;         R4: BYTE {R4}
;         R5: BYTE {R5}
;         R6: BYTE {R6}
;
; Outputs: R1: BYTE {R1}
;          R2: BYTE {R2}
;          R3: BYTE {R3}
;          R4: BYTE {R4}
;          R5: BYTE {R5}
;          R6: BYTE {R6}
;
; Algorithm:
;
;  Begin
;    Shift the syndromes right 1 bit with carry
;    If the LSB of R6 was a 1 {if carry}
;      Then
;        R1:=R1 Xor 140
;        R2:=R3 Xor 12
;        R3:=R3 Xor 10
;        R4:=R4 Xor 40
;        R5:=R5 Xor 24
;        R6:=R6 Xor 8
;  End
;
;********************************************************************

ShiftAndXor	ld R12, #6		; shift 6 bytes
		ld R13, #Wrk_Sys+1	; start with R1
		rcf
;
S_A_Xor_Lp	rrc @R13
		inc R13
		djnz R12, S_A_Xor_Lp
;
		jr NC, S_A_Xor_End
		xor R1, #140
		xor R2, #12
		xor R3, #10
		xor R4, #40
		xor R5, #24
		xor R6, #8
S_A_Xor_End	or R1, R1		; If R1=0 ...
		ret


;********************************************************************
;
; Procedure: TestMod8
;
;  This procedure is used to test if J mod 8 = 0.
;
; Inputs: J: WORD {RR8}
;
; Outputs: none
;
; Global Variables Changed: Done:        BOOLEAN {R7/bit 5}
;                           Correctable: BOOLEAN {R7/bit 7}
;
; Algorithm:
;
;  Begin
;    If J mod 8 = 0
;      Then
;        Done:=true
;        Correctable:=true
;  End
;
;********************************************************************

TestMod8	ld R0, R9
		and R0, #7		; get remainder from division
		jr NZ,TstMd8_Done
		or R7, #Ecc_Done+Ecc_Correctable
TstMd8_Done	ret    


;********************************************************************
;
; Procedure: Test0
;
;  This procedure is used to test if J=0.
;
; Inputs: J: WORD {RR8}
;
; Outputs: none
;
; Global Variables Changed: Done:        BOOLEAN {R7/bit 5}
;                           Correctable: BOOLEAN {R7/bit 7}
;
; Algorithm:
;
;  Begin
;    If J=0
;      Then
;        Done:=true
;        Correctable:=true
;  End
;
;********************************************************************

Test0		ld R0, R8
		or R0, R9		; If J=0 ...
		jr NZ,Test0_Done
		or R7, #Ecc_Done
		and R7, #0FFh-Ecc_Correctable
Test0_Done	ret    


L2CE4		DB 000h, 001h, 000h, 001h
		DB 0E6h, 000h, 098h, 035h

; Cmd 3
; build something together inside the RW buffer
L2CEC		ld R0, #0
		call L05a3
		ld R2, #010h
		ld R3, #020h
		lde R0, @RR2
		ld 5Dh, R0	; preserve value from 1020h
		ld R12, #010h
		ld R13, #019h
		ld R14, #L2CE4 /256
		ld R15, #L2CE4 #256
		ld R1, #8
L2d03		Ldc R0, @RR14	; copy 8 bytes from table
		lde @RR12, R0	;  into 1019h ff (RBuffer1 ???)
		incw RR12
		incw RR14
		djnz R1, L2d03
		ld R14, #SprCount /256
		ld R15, #SprCount #256
		ld R2, #0	; R2 = 0
		lde R3, @RR14
		ld R5, #76
		sub R5, R3
		ld R3, R5	; R3 = remaining spares
		incw RR14	; bad block count
		ld R4, #0	; R4 = 0
		lde R5, @RR14	; R5 = bad block count
		ld R6,SlfTst_Result	; R6 = selftest result
		ld R7,72h	; R7 = 72h
		ld R0, #012h	; start with register R2
		ld R1, #6
L2d29		ldei @RR12, @R0	; copy six registers 
		djnz R1, L2d29	;  into buffer
		ld R0, #011h
		ld R1, #029h
		ld R2, #0FFh
		ld R3, #36
L2d35		lde @RR0, R2	; copy 36x FFh 
		incw RR0	; into 1129h ff
		djnz R3, L2d35
		ld R8, #080h
		clr R9
		clr R10
		ld R11, #1
		ld R0, #010h
		ld R1, #0A9h
		ld R2, #9
L2d49		call L2d7d	; copy 80 00 00 01 into 10A9h ff
		djnz R2, L2d49
		com R8
		com R9
		com R10
		com R11
		ld R0, #010h
		ld R1, #0A5h
		call L2d7d
		ld R0, #010h
		ld R1, #0CDh
		call L2d7d
		ld R0, #011h
		ld R1, #025h
		call L2d7d
		ld R0, #011h
		ld R1, #04Dh
		call L2d7d
		ld R0, #010h
		ld R1, #0C1h
		ld R2, #088h
		lde @RR0, R2
		jp Bank_Ret

L2d7d		ld R4, #004h
		ld R3, #018h
L2d81		ldei @RR0, @R3
		djnz R4, L2d81
		ret    

FormatTrack	call L0586
		ld R0, #0C6h
		call L059d
		tm 3Eh, #HDA_Type	; Nisha mechnism?
		jr Z, L2da7		;  yes --> skip selfsync 
; write Rodime selfsync pattern
		ld R2, #FormatArray /256
		ld R3, #FormatArray #256
		ld R14, #L2e12 /256
		ld R15, #L2e12 #256
		ld R1, #50		
L2d9d		Ldc R0, @RR14
		lde @RR2, R0
		incw RR2
		incw RR14
		djnz R1, L2d9d
;
L2da7		ld R2, #FHdrSync /256
		ld R3, #FHdrSync #256
		ld R4, #FDataSync /256
		ld R5, #FDataSync #256
		ld R0, #1
		lde @RR2, R0
		lde @RR4, R0
		incw RR2
		incw RR4
		ld R0, #0
		lde @RR2, R0
		lde @RR4, R0
		or DiskStat, #Wr_Op
		ld Sector, #0
		tm 3Eh, #HDA_Type	; Nisha mechnism?
		jr Z, L2ddd		;  yes --> 
;
		ld Sector, #31
		call AdjustGeometry
		and IRQ, #0FFh-Irq_Sector
		ld R2, #001h
		call L069d
		ld Sector, #0
		jr L2de0
;
L2ddd		call AdjustGeometry
L2de0		ld R4, #NbrSctrs
L2de2		ld R2, #FHeader /256
		ld R3, #FHeader #256
		call Load_Header
		call L048f
		call L0205
		and R5, #077h
		cp R5, #062h
		jp NZ, L0651
		add Sector, #2		; 2:1 interleave
		cp Sector, #NbrSctrs
		jr NZ, L2e0d
		ld Sector, #1
FmtT_1		tm P3, #IndexMark	; while not index
		jr Z, FmtT_1
L2e08		tm P3, #SectorMark
		jr Z, L2e08
L2e0d		djnz R4, L2de2
		jp Bank_Ret

L2e12  		DB 000h, 000h, 000h, 000h
		DB 000h, 000h, 000h, 000h
		DB 000h, 000h, 000h, 000h
		DB 000h, 000h, 000h, 000h
		DB 000h, 0FFh, 0FFh, 0FFh
		DB 0FFh, 0FFh, 0FFh, 0FFh
		DB 0FFh, 0FFh, 001h, 000h
		DB 000h, 000h, 000h, 000h
		DB 000h, 000h, 000h, 049h
		DB 024h, 092h, 049h, 024h
		DB 092h, 049h, 024h, 092h
		DB 049h, 024h, 092h, 0ffh
		DB 001h, 000h


; Cmd 19
L2e44		or 50h, #1
		ld R0, #0
		call L05a3
		jr L2e51

; Cmd 20
L2E4E		and 50h, #0FFh-001h
L2e51		or SlfTst_Result,SlfTst_Result
		jr Z, L2e5b
		ld R15, #57
		jp Abort
;
L2e5b		ld R2, #010h
		ld R3, #020h
		lde R0, @RR2
		cp R0,5Dh
		jr Z, L2e6b
		ld R15, #61
		jp Abort
;
L2e6b		ld R12, #0
		ld R13, #0
		ld R14, #0
		ld R15, #0
		jr L2e7f
;
L2e75		cp R12,Cur_Cyl
		jr NZ, L2e7f
		cp R13,Cur_Cyl+1
		jr Z, L2e91
L2e7f		or DiskStat, #Offset_On
		and DiskStat, #0FFh-Offset_Set
		call Seek
		call L2f99
		jr NZ, L2e9b
		ld R15, #2
		jr L2e9b

L2e91		cp R14,Head
		jr Z, L2e9b
		ld R0, R14
		call SelectHead
L2e9b		or DiskStat, #4
		ld Sector, R15
		and DiskStat, #0DFh
		tm 50h, #001h
		jr Z, L2eab
		or DiskStat, #020h
L2eab		and 3Eh, #0FFh-S_Block-B_Block-002h
		ld R2, #RW_Common /256
		ld R3, #RW_Common #256
		call Bank_Call
		jp NZ, L2f53
		cp R0, #086h
		jp Z, L2f53
		call Ext_Push
		ld R0, #6
		tm 3Eh, #HDA_Type	; Nisha mechanism?
		jr Z, L2eca		;  yes -->
		ld R0, #7
L2eca		rcf    
		rlc R13
		rlc R12
		djnz R0, L2eca
		ld R0, #005h
L2ed3		rcf    
		rlc R14
		djnz R0, L2ed3
		ld R2, #016h
		ld R3, #01Bh
		ld R1, #020h
L2ede		lde R0, @RR2
		cp R0, R15
		jr Z, L2eed
		incw RR2
		djnz R1, L2ede
		ld R15, #58
		jp Abort

L2eed		ld R15, #020h
		sub R15, R1
		add R14, R15
		adc R13, #0
		adc R12, #0
		add R13, R14
		adc R12, #0
		ld R14, R13
		ld R13, R12
		ld R12, #0
		or R14, R14
		jr Z, L2f50
		tm R13, #1
		jr Z, L2f50
		ld R3, #9
		call L215b
		ld R12, #0
		sub R14, R2
		sbc R13, R1
		ld R0, #HiMaxLogical
		ld R1, #MidMaxLogical
		ld R2, #LoMaxLogical
		call L0459
		jr LT, L2f94
		ld R2, #LogicalBlock /256
		ld R3, #LogicalBlock #256
		ld R1, #01Ch
		ldei @RR2, @R1
		ldei @RR2, @R1
		ldei @RR2, @R1
		ld R2, #CnvrtLogical /256
		ld R3, #CnvrtLogical #256
		call Bank_Call
		jr NZ, L2f94
		ld R0, #082h
		tm 50h, #1
		jr NZ, L2f41
		ld R0, #132
L2f41		or DiskStat, #User_Type
		ld R2, #Data_Ex_Handler /256
		ld R3, #Data_Ex_Handler #256
		call Bank_Call
		ld R0, #0
		call L05a3
L2f50		call Ext_Pop
L2f53		add R15, #2
		cp R15, #021h
		jr Z, L2f65
		cp R15, #020h
		jr NZ, L2f62
		ld R15, #1
L2f62		jp L2e75

L2f65		ld R15, #0
		inc R14
		ld R0, #NbrHds_B	; assume Nisha
		tm 3Eh, #HDA_Type	; do we have a Nisha HDA?
		jr Z, L2f71		;  yes -->
		ld R0, #NbrHds_A	;  else use Rodime value
L2f71		cp R0, R14
		jp NZ, L2e75
		ld R14, #0
		incw RR12
		ld R0, #NbrTracks_B /256
		ld R1, #NbrTracks_B #256
		tm 3Eh, #HDA_Type	; do we have a Nisha HDA?
		jr Z, L2f87		;  yes --> 
		ld R0, #NbrTracks_A /256
		ld R1, #NbrTracks_A #256
L2f87		cp R0, R12
		jp NZ, L2e75
		cp R1, R13
		jp NZ, L2e75
L2f91		jp Bank_Ret

L2f94		call Ext_Pop
		jr L2f91

L2f99		ld R4, #2
		call Ext_Push
L2f9e		ld R8, R4
		call Spr
		and DiskStat, #251
		ld R2, #CnvrtLogical /256
		ld R3, #CnvrtLogical #256
		call Bank_Call
		cp R12,Cur_Cyl
		jr NZ, L2fbc
		cp R13,Cur_Cyl+1
		jr NZ, L2fbc
		cp R14,Head
		jr Z, L2fc1
L2fbc		djnz R4, L2f9e
		or R0, #1
L2fc1		push FLAGS
		call Ext_Pop
		pop FLAGS
		jp Bank_Ret

	dephase
	if $>ROMsize
		error "\aROM size exceeded !!!"
	elseif
		DB ROMsize-$ dup(0FFh)	; pad with LFF's
	endif
	end

